/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.fishing;

import com.cobblemon.mod.common.api.conditional.CodecsKt;
import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.fishing.BaitEffectFunctionRegistryEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.spawning.fishing.FishingSpawnCause;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00102\u00020\u0001:\u0003\u0011\u0010\u0012B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/api/fishing/SpawnBait;", "", "Lcom/cobblemon/mod/common/api/conditional/RegistryLikeCondition;", "Lnet/minecraft/world/item/Item;", "item", "", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "effects", "<init>", "(Lcom/cobblemon/mod/common/api/conditional/RegistryLikeCondition;Ljava/util/List;)V", "Lcom/cobblemon/mod/common/api/conditional/RegistryLikeCondition;", "getItem", "()Lcom/cobblemon/mod/common/api/conditional/RegistryLikeCondition;", "Ljava/util/List;", "getEffects", "()Ljava/util/List;", "Companion", "Effect", "Effects", "common"})
public final class SpawnBait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegistryLikeCondition<Item> item;
    @NotNull
    private final List<Effect> effects;
    private static final Codec<SpawnBait> CODEC = RecordCodecBuilder.create(SpawnBait::CODEC$lambda$0);
    private static final StreamCodec<ByteBuf, SpawnBait> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public SpawnBait(@NotNull RegistryLikeCondition<Item> item, @NotNull List<Effect> effects) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        this.item = item;
        this.effects = effects;
    }

    @NotNull
    public final RegistryLikeCondition<Item> getItem() {
        return this.item;
    }

    @NotNull
    public final List<Effect> getEffects() {
        return this.effects;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)CodecsKt.getITEM_REGISTRY_LIKE_CODEC().fieldOf("item").forGetter(SpawnBait::CODEC$lambda$0$0), (App)Effect.Companion.getCODEC().listOf().fieldOf("effects").forGetter(SpawnBait::CODEC$lambda$0$1)).apply((Applicative)instance, SpawnBait::new);
    }

    private static final RegistryLikeCondition CODEC$lambda$0$0(SpawnBait it) {
        return it.item;
    }

    private static final List CODEC$lambda$0$1(SpawnBait it) {
        return it.effects;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nRW\u0010\r\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final Codec<SpawnBait> getCODEC() {
            return CODEC;
        }

        public final StreamCodec<ByteBuf, SpawnBait> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0010J:\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b \u0010\rR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b#\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "", "Lnet/minecraft/resources/ResourceLocation;", "type", "subcategory", "", "chance", "value", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;DD)V", "Ljava/util/Optional;", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Optional;DD)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "component2", "component3", "()D", "component4", "copy", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;DD)Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "getType", "getSubcategory", "D", "getChance", "getValue", "Companion", "common"})
    public static final class Effect {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation type;
        @Nullable
        private final ResourceLocation subcategory;
        private final double chance;
        private final double value;
        private static final Codec<Effect> CODEC = RecordCodecBuilder.create(Effect::CODEC$lambda$0);

        public Effect(@NotNull ResourceLocation type, @Nullable ResourceLocation subcategory, double chance, double value) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.subcategory = subcategory;
            this.chance = chance;
            this.value = value;
        }

        public /* synthetic */ Effect(ResourceLocation resourceLocation, ResourceLocation resourceLocation2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                d = 0.0;
            }
            if ((n & 8) != 0) {
                d2 = 0.0;
            }
            this(resourceLocation, resourceLocation2, d, d2);
        }

        @NotNull
        public final ResourceLocation getType() {
            return this.type;
        }

        @Nullable
        public final ResourceLocation getSubcategory() {
            return this.subcategory;
        }

        public final double getChance() {
            return this.chance;
        }

        public final double getValue() {
            return this.value;
        }

        public Effect(@NotNull ResourceLocation type, @NotNull Optional<ResourceLocation> subcategory, double chance, double value) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(subcategory, (String)"subcategory");
            this(type, (ResourceLocation)subcategory.orElse(null), chance, value);
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.type;
        }

        @Nullable
        public final ResourceLocation component2() {
            return this.subcategory;
        }

        public final double component3() {
            return this.chance;
        }

        public final double component4() {
            return this.value;
        }

        @NotNull
        public final Effect copy(@NotNull ResourceLocation type, @Nullable ResourceLocation subcategory, double chance, double value) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Effect(type, subcategory, chance, value);
        }

        public static /* synthetic */ Effect copy$default(Effect effect, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = effect.type;
            }
            if ((n & 2) != 0) {
                resourceLocation2 = effect.subcategory;
            }
            if ((n & 4) != 0) {
                d = effect.chance;
            }
            if ((n & 8) != 0) {
                d2 = effect.value;
            }
            return effect.copy(resourceLocation, resourceLocation2, d, d2);
        }

        @NotNull
        public String toString() {
            return "Effect(type=" + this.type + ", subcategory=" + this.subcategory + ", chance=" + this.chance + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + (this.subcategory == null ? 0 : this.subcategory.hashCode());
            result = result * 31 + Double.hashCode(this.chance);
            result = result * 31 + Double.hashCode(this.value);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Effect)) {
                return false;
            }
            Effect effect = (Effect)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)effect.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.subcategory, (Object)effect.subcategory)) {
                return false;
            }
            if (Double.compare(this.chance, effect.chance) != 0) {
                return false;
            }
            return Double.compare(this.value, effect.value) == 0;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(Effect::CODEC$lambda$0$0), (App)ResourceLocation.CODEC.optionalFieldOf("subcategory").forGetter(Effect::CODEC$lambda$0$1), (App)Codec.DOUBLE.fieldOf("chance").forGetter(Effect::CODEC$lambda$0$2), (App)Codec.DOUBLE.fieldOf("value").forGetter(Effect::CODEC$lambda$0$3)).apply((Applicative)instance, Effect::new);
        }

        private static final ResourceLocation CODEC$lambda$0$0(Effect it) {
            return it.type;
        }

        private static final Optional CODEC$lambda$0$1(Effect it) {
            return Optional.ofNullable(it.subcategory);
        }

        private static final Double CODEC$lambda$0$2(Effect it) {
            return it.chance;
        }

        private static final Double CODEC$lambda$0$3(Effect it) {
            return it.value;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
        public static final class Companion {
            private Companion() {
            }

            public final Codec<Effect> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b!\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0003R2\u0010\u0011\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016R\u0017\u0010\u001b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u001d\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001e\u0010\u0016R\u0017\u0010\u001f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0016R\u0017\u0010!\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0014\u001a\u0004\b\"\u0010\u0016R\u0017\u0010#\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b$\u0010\u0016R\u0017\u0010%\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u0014\u001a\u0004\b&\u0010\u0016R\u0017\u0010'\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b'\u0010\u0014\u001a\u0004\b(\u0010\u0016R\u0017\u0010)\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u0014\u001a\u0004\b*\u0010\u0016R\u0017\u0010+\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b+\u0010\u0014\u001a\u0004\b,\u0010\u0016R\u0017\u0010-\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b-\u0010\u0014\u001a\u0004\b.\u0010\u0016R\u0017\u0010/\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b/\u0010\u0014\u001a\u0004\b0\u0010\u0016\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effects;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "type", "Lkotlin/Function2;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "", "effect", "registerEffect", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function2;)V", "getEffectFunction", "(Lnet/minecraft/resources/ResourceLocation;)Lkotlin/jvm/functions/Function2;", "setupEffects", "", "EFFECT_FUNCTIONS", "Ljava/util/Map;", "NATURE", "Lnet/minecraft/resources/ResourceLocation;", "getNATURE", "()Lnet/minecraft/resources/ResourceLocation;", "IV", "getIV", "EV", "getEV", "BITE_TIME", "getBITE_TIME", "GENDER_CHANCE", "getGENDER_CHANCE", "LEVEL_RAISE", "getLEVEL_RAISE", "TYPING", "getTYPING", "EGG_GROUP", "getEGG_GROUP", "SHINY_REROLL", "getSHINY_REROLL", "DROPS_REROLL", "getDROPS_REROLL", "HIDDEN_ABILITY_CHANCE", "getHIDDEN_ABILITY_CHANCE", "POKEMON_CHANCE", "getPOKEMON_CHANCE", "FRIENDSHIP", "getFRIENDSHIP", "RARITY_BUCKET", "getRARITY_BUCKET", "common"})
    @SourceDebugExtension(value={"SMAP\nSpawnBait.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnBait.kt\ncom/cobblemon/mod/common/api/fishing/SpawnBait$Effects\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n17#2,2:103\n19#2:109\n13805#3:105\n13806#3:108\n216#4,2:106\n*S KotlinDebug\n*F\n+ 1 SpawnBait.kt\ncom/cobblemon/mod/common/api/fishing/SpawnBait$Effects\n*L\n94#1:103,2\n94#1:109\n94#1:105\n94#1:108\n95#1:106,2\n*E\n"})
    public static final class Effects {
        @NotNull
        public static final Effects INSTANCE = new Effects();
        @NotNull
        private static final Map<ResourceLocation, Function2<PokemonEntity, Effect, Unit>> EFFECT_FUNCTIONS = new LinkedHashMap();
        @NotNull
        private static final ResourceLocation NATURE = MiscUtilsKt.cobblemonResource("nature");
        @NotNull
        private static final ResourceLocation IV = MiscUtilsKt.cobblemonResource("iv");
        @NotNull
        private static final ResourceLocation EV = MiscUtilsKt.cobblemonResource("ev");
        @NotNull
        private static final ResourceLocation BITE_TIME = MiscUtilsKt.cobblemonResource("bite_time");
        @NotNull
        private static final ResourceLocation GENDER_CHANCE = MiscUtilsKt.cobblemonResource("gender_chance");
        @NotNull
        private static final ResourceLocation LEVEL_RAISE = MiscUtilsKt.cobblemonResource("level_raise");
        @NotNull
        private static final ResourceLocation TYPING = MiscUtilsKt.cobblemonResource("typing");
        @NotNull
        private static final ResourceLocation EGG_GROUP = MiscUtilsKt.cobblemonResource("egg_group");
        @NotNull
        private static final ResourceLocation SHINY_REROLL = MiscUtilsKt.cobblemonResource("shiny_reroll");
        @NotNull
        private static final ResourceLocation DROPS_REROLL = MiscUtilsKt.cobblemonResource("drops_reroll");
        @NotNull
        private static final ResourceLocation HIDDEN_ABILITY_CHANCE = MiscUtilsKt.cobblemonResource("ha_chance");
        @NotNull
        private static final ResourceLocation POKEMON_CHANCE = MiscUtilsKt.cobblemonResource("pokemon_chance");
        @NotNull
        private static final ResourceLocation FRIENDSHIP = MiscUtilsKt.cobblemonResource("friendship");
        @NotNull
        private static final ResourceLocation RARITY_BUCKET = MiscUtilsKt.cobblemonResource("rarity_bucket");

        private Effects() {
        }

        @NotNull
        public final ResourceLocation getNATURE() {
            return NATURE;
        }

        @NotNull
        public final ResourceLocation getIV() {
            return IV;
        }

        @NotNull
        public final ResourceLocation getEV() {
            return EV;
        }

        @NotNull
        public final ResourceLocation getBITE_TIME() {
            return BITE_TIME;
        }

        @NotNull
        public final ResourceLocation getGENDER_CHANCE() {
            return GENDER_CHANCE;
        }

        @NotNull
        public final ResourceLocation getLEVEL_RAISE() {
            return LEVEL_RAISE;
        }

        @NotNull
        public final ResourceLocation getTYPING() {
            return TYPING;
        }

        @NotNull
        public final ResourceLocation getEGG_GROUP() {
            return EGG_GROUP;
        }

        @NotNull
        public final ResourceLocation getSHINY_REROLL() {
            return SHINY_REROLL;
        }

        @NotNull
        public final ResourceLocation getDROPS_REROLL() {
            return DROPS_REROLL;
        }

        @NotNull
        public final ResourceLocation getHIDDEN_ABILITY_CHANCE() {
            return HIDDEN_ABILITY_CHANCE;
        }

        @NotNull
        public final ResourceLocation getPOKEMON_CHANCE() {
            return POKEMON_CHANCE;
        }

        @NotNull
        public final ResourceLocation getFRIENDSHIP() {
            return FRIENDSHIP;
        }

        @NotNull
        public final ResourceLocation getRARITY_BUCKET() {
            return RARITY_BUCKET;
        }

        public final void registerEffect(@NotNull ResourceLocation type, @NotNull Function2<? super PokemonEntity, ? super Effect, Unit> effect) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(effect, (String)"effect");
            EFFECT_FUNCTIONS.put(type, effect);
        }

        @Nullable
        public final Function2<PokemonEntity, Effect, Unit> getEffectFunction(@NotNull ResourceLocation type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return EFFECT_FUNCTIONS.get(type);
        }

        /*
         * WARNING - void declaration
         */
        public final void setupEffects() {
            void events$iv;
            void this_$iv;
            this.registerEffect(NATURE, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$0));
            this.registerEffect(IV, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$1));
            this.registerEffect(SHINY_REROLL, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$2));
            this.registerEffect(DROPS_REROLL, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$3));
            this.registerEffect(GENDER_CHANCE, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$4));
            this.registerEffect(LEVEL_RAISE, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$5));
            this.registerEffect(HIDDEN_ABILITY_CHANCE, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$6));
            this.registerEffect(FRIENDSHIP, (Function2<? super PokemonEntity, ? super Effect, Unit>)((Function2)Effects::setupEffects$lambda$7));
            EventObservable<BaitEffectFunctionRegistryEvent> eventObservable = CobblemonEvents.BAIT_EFFECT_REGISTRATION;
            BaitEffectFunctionRegistryEvent[] baitEffectFunctionRegistryEventArray = new BaitEffectFunctionRegistryEvent[]{new BaitEffectFunctionRegistryEvent()};
            boolean $i$f$post = false;
            this_$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
            void $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void event = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                Map<ResourceLocation, Function2<PokemonEntity, Effect, Unit>> $this$forEach$iv = event.getFunctions();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<ResourceLocation, Function2<PokemonEntity, Effect, Unit>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ResourceLocation, Function2<PokemonEntity, Effect, Unit>> element$iv;
                    Map.Entry<ResourceLocation, Function2<PokemonEntity, Effect, Unit>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    ResourceLocation type = entry.getKey();
                    Function2<PokemonEntity, Effect, Unit> function = entry.getValue();
                    INSTANCE.registerEffect(type, function);
                }
            }
        }

        private static final Unit setupEffects$lambda$0(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.alterNatureAttempt(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$1(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.alterIVAttempt(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$2(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.shinyReroll(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$3(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.saveDropsReroll(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$4(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.alterGenderAttempt(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$5(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.alterLevelAttempt(entity, effect);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$6(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"<unused var>");
            FishingSpawnCause.Companion.alterHAAttempt(entity);
            return Unit.INSTANCE;
        }

        private static final Unit setupEffects$lambda$7(PokemonEntity entity, Effect effect) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            FishingSpawnCause.Companion.alterFriendshipAttempt(entity, effect);
            return Unit.INSTANCE;
        }
    }
}

