/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.dialogue.input;

import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.api.dialogue.ActiveDialogue;
import com.cobblemon.mod.common.api.dialogue.input.DialogueInput;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/cobblemon/mod/common/api/dialogue/input/ActiveInput;", "", "Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "activeDialogue", "Lcom/cobblemon/mod/common/api/dialogue/input/DialogueInput;", "dialogueInput", "<init>", "(Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;Lcom/cobblemon/mod/common/api/dialogue/input/DialogueInput;)V", "", "input", "", "handle", "(Ljava/lang/String;)V", "Lcom/bedrockk/molang/runtime/value/MoValue;", "toMoLangStruct", "()Lcom/bedrockk/molang/runtime/value/MoValue;", "Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "getActiveDialogue", "()Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "Lcom/cobblemon/mod/common/api/dialogue/input/DialogueInput;", "getDialogueInput", "()Lcom/cobblemon/mod/common/api/dialogue/input/DialogueInput;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "inputId", "Ljava/util/UUID;", "getInputId", "()Ljava/util/UUID;", "", "startTime", "J", "getStartTime", "()J", "struct", "Lcom/bedrockk/molang/runtime/value/MoValue;", "getStruct", "common"})
public final class ActiveInput {
    @NotNull
    private final ActiveDialogue activeDialogue;
    @NotNull
    private final DialogueInput dialogueInput;
    private final UUID inputId;
    private final long startTime;
    @NotNull
    private final MoValue struct;

    public ActiveInput(@NotNull ActiveDialogue activeDialogue, @NotNull DialogueInput dialogueInput) {
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        Intrinsics.checkNotNullParameter((Object)dialogueInput, (String)"dialogueInput");
        this.activeDialogue = activeDialogue;
        this.dialogueInput = dialogueInput;
        this.inputId = UUID.randomUUID();
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        this.startTime = minecraftServer.overworld().getGameTime();
        this.struct = this.toMoLangStruct();
    }

    @NotNull
    public final ActiveDialogue getActiveDialogue() {
        return this.activeDialogue;
    }

    @NotNull
    public final DialogueInput getDialogueInput() {
        return this.dialogueInput;
    }

    public final UUID getInputId() {
        return this.inputId;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final MoValue getStruct() {
        return this.struct;
    }

    public final void handle(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        float secondsToChoose = (float)(minecraftServer.overworld().getGameTime() - this.startTime) / 20.0f;
        this.activeDialogue.getRuntime().getEnvironment().setSimpleVariable("seconds_taken_to_input", new DoubleValue(Float.valueOf(secondsToChoose)));
        this.dialogueInput.handle(this, input);
    }

    @NotNull
    public final MoValue toMoLangStruct() {
        return this.dialogueInput.toMoLangStruct(this);
    }
}

