/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.dialogue;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.struct.MoStruct;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import com.bedrockk.molang.runtime.value.StringValue;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.dialogue.Dialogue;
import com.cobblemon.mod.common.api.dialogue.DialogueAction;
import com.cobblemon.mod.common.api.dialogue.DialogueManager;
import com.cobblemon.mod.common.api.dialogue.DialoguePage;
import com.cobblemon.mod.common.api.dialogue.input.ActiveInput;
import com.cobblemon.mod.common.api.dialogue.input.DialogueTimeout;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.scheduling.ServerRealTimeTaskTracker;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.net.messages.client.dialogue.DialogueOpenedPacket;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\r\u0010\u0015J\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\r\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\nJ\r\u0010\u001d\u001a\u00020\b\u00a2\u0006\u0004\b\u001d\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010,R\u001f\u0010/\u001a\n .*\u0004\u0018\u00010-0-8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R$\u00109\u001a\u0004\u0018\u0001088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010?\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010\u0015R\u001d\u0010F\u001a\b\u0012\u0004\u0012\u00020E0D8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\"\u0010K\u001a\u00020J8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001d\u0010R\u001a\b\u0012\u0004\u0012\u00020\b0Q8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010UR\u0011\u0010X\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bV\u0010W\u00a8\u0006Y"}, d2={"Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "Lcom/cobblemon/mod/common/api/dialogue/Dialogue;", "dialogueReference", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/dialogue/Dialogue;)V", "", "initialize", "()V", "Lcom/bedrockk/molang/runtime/value/MoValue;", "value", "setPage", "(Lcom/bedrockk/molang/runtime/value/MoValue;)V", "", "isActive", "()Z", "incrementPage", "Lcom/cobblemon/mod/common/api/dialogue/DialoguePage;", "page", "(Lcom/cobblemon/mod/common/api/dialogue/DialoguePage;)V", "", "index", "(I)V", "Lcom/bedrockk/molang/runtime/struct/MoStruct;", "toMoLangStruct", "()Lcom/bedrockk/molang/runtime/struct/MoStruct;", "close", "escape", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayerEntity", "()Lnet/minecraft/server/level/ServerPlayer;", "setPlayerEntity", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/dialogue/Dialogue;", "getDialogueReference", "()Lcom/cobblemon/mod/common/api/dialogue/Dialogue;", "setDialogueReference", "(Lcom/cobblemon/mod/common/api/dialogue/Dialogue;)V", "initialized", "Z", "getInitialized", "setInitialized", "(Z)V", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "dialogueId", "Ljava/util/UUID;", "getDialogueId", "()Ljava/util/UUID;", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "runtime", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "getRuntime", "()Lcom/bedrockk/molang/runtime/MoLangRuntime;", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "npc", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "getNpc", "()Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "setNpc", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;)V", "currentPage", "Lcom/cobblemon/mod/common/api/dialogue/DialoguePage;", "getCurrentPage", "()Lcom/cobblemon/mod/common/api/dialogue/DialoguePage;", "setCurrentPage", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/world/entity/player/Player;", "playerStruct", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "getPlayerStruct", "()Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lcom/cobblemon/mod/common/api/dialogue/input/ActiveInput;", "activeInput", "Lcom/cobblemon/mod/common/api/dialogue/input/ActiveInput;", "getActiveInput", "()Lcom/cobblemon/mod/common/api/dialogue/input/ActiveInput;", "setActiveInput", "(Lcom/cobblemon/mod/common/api/dialogue/input/ActiveInput;)V", "Ljava/util/concurrent/CompletableFuture;", "completion", "Ljava/util/concurrent/CompletableFuture;", "getCompletion", "()Ljava/util/concurrent/CompletableFuture;", "getCurrentPageIndex", "()I", "currentPageIndex", "common"})
@SourceDebugExtension(value={"SMAP\nActiveDialogue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActiveDialogue.kt\ncom/cobblemon/mod/common/api/dialogue/ActiveDialogue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class ActiveDialogue {
    @NotNull
    private ServerPlayer playerEntity;
    @NotNull
    private Dialogue dialogueReference;
    private boolean initialized;
    private final UUID dialogueId;
    @NotNull
    private final MoLangRuntime runtime;
    @Nullable
    private NPCEntity npc;
    @NotNull
    private DialoguePage currentPage;
    @NotNull
    private final ObjectValue<Player> playerStruct;
    @NotNull
    private ActiveInput activeInput;
    @NotNull
    private final CompletableFuture<Unit> completion;

    public ActiveDialogue(@NotNull ServerPlayer playerEntity, @NotNull Dialogue dialogueReference) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)dialogueReference, (String)"dialogueReference");
        this.playerEntity = playerEntity;
        this.dialogueReference = dialogueReference;
        this.dialogueId = UUID.randomUUID();
        this.runtime = MoLangFunctions.INSTANCE.setup(new MoLangRuntime());
        this.currentPage = this.dialogueReference.getPages().get(0);
        this.playerStruct = MoLangFunctions.INSTANCE.asMoLangValue((Player)this.playerEntity);
        this.activeInput = new ActiveInput(this, this.currentPage.getInput());
        this.completion = new CompletableFuture();
    }

    @NotNull
    public final ServerPlayer getPlayerEntity() {
        return this.playerEntity;
    }

    public final void setPlayerEntity(@NotNull ServerPlayer serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<set-?>");
        this.playerEntity = serverPlayer;
    }

    @NotNull
    public final Dialogue getDialogueReference() {
        return this.dialogueReference;
    }

    public final void setDialogueReference(@NotNull Dialogue dialogue) {
        Intrinsics.checkNotNullParameter((Object)dialogue, (String)"<set-?>");
        this.dialogueReference = dialogue;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public final UUID getDialogueId() {
        return this.dialogueId;
    }

    @NotNull
    public final MoLangRuntime getRuntime() {
        return this.runtime;
    }

    @Nullable
    public final NPCEntity getNpc() {
        return this.npc;
    }

    public final void setNpc(@Nullable NPCEntity nPCEntity) {
        this.npc = nPCEntity;
    }

    @NotNull
    public final DialoguePage getCurrentPage() {
        return this.currentPage;
    }

    public final void setCurrentPage(@NotNull DialoguePage dialoguePage) {
        Intrinsics.checkNotNullParameter((Object)dialoguePage, (String)"<set-?>");
        this.currentPage = dialoguePage;
    }

    @NotNull
    public final ObjectValue<Player> getPlayerStruct() {
        return this.playerStruct;
    }

    @NotNull
    public final ActiveInput getActiveInput() {
        return this.activeInput;
    }

    public final void setActiveInput(@NotNull ActiveInput activeInput) {
        Intrinsics.checkNotNullParameter((Object)activeInput, (String)"<set-?>");
        this.activeInput = activeInput;
    }

    @NotNull
    public final CompletableFuture<Unit> getCompletion() {
        return this.completion;
    }

    public final void initialize() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dialogue", arg_0 -> ActiveDialogue.initialize$lambda$0(this, arg_0)), TuplesKt.to((Object)"player", arg_0 -> ActiveDialogue.initialize$lambda$1(this, arg_0))};
        MoLangFunctions.INSTANCE.addFunctions(this.runtime.getEnvironment().query, MapsKt.mapOf((Pair[])pairArray));
        DialogueAction.invoke$default(this.dialogueReference.getInitializationAction(), this, null, 2, null);
        this.setPage(this.currentPage);
        if (!this.completion.isDone()) {
            DialogueOpenedPacket packet = new DialogueOpenedPacket(this, true);
            CobblemonNetwork.INSTANCE.sendPacket(this.playerEntity, packet);
        }
        this.initialized = true;
    }

    public final int getCurrentPageIndex() {
        return this.dialogueReference.getPages().indexOf(this.currentPage);
    }

    public final void setPage(@NotNull MoValue value) {
        DialoguePage dialoguePage;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof StringValue) {
            Object v0;
            block5: {
                Iterable iterable = this.dialogueReference.getPages();
                for (Object t : iterable) {
                    DialoguePage it = (DialoguePage)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((StringValue)value).value)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            if ((dialoguePage = (DialoguePage)v0) == null) {
                Cobblemon.LOGGER.error("Dialogue requested page " + ((StringValue)value).value + " but it doesn't exist");
                return;
            }
        } else {
            int pageNum = (int)value.asDouble();
            if (pageNum < 0 || pageNum >= this.dialogueReference.getPages().size()) {
                Cobblemon.LOGGER.error("Dialogue requested page " + pageNum + " but it doesn't exist");
                return;
            }
            dialoguePage = this.dialogueReference.getPages().get(pageNum);
        }
        DialoguePage page = dialoguePage;
        this.setPage(page);
    }

    public final boolean isActive() {
        return Intrinsics.areEqual((Object)DialogueManager.INSTANCE.getActiveDialogues().get(this.playerEntity.getUUID()), (Object)this);
    }

    public final void incrementPage() {
        this.setPage(this.getCurrentPageIndex() + 1);
    }

    public final void setPage(@NotNull DialoguePage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.currentPage = page;
        this.activeInput = new ActiveInput(this, this.currentPage.getInput());
        DialogueTimeout dialogueTimeout = this.currentPage.getInput().getTimeout();
        Float deadline = dialogueTimeout != null ? Float.valueOf(dialogueTimeout.getDuration()) : null;
        UUID inputId = this.activeInput.getInputId();
        if (deadline != null && deadline.floatValue() > 0.0f) {
            ServerRealTimeTaskTracker.INSTANCE.after(deadline.floatValue(), (Function0<Unit>)((Function0)() -> ActiveDialogue.setPage$lambda$1(inputId, this)));
        }
        if (this.initialized) {
            CobblemonNetwork.INSTANCE.sendPacket(this.playerEntity, new DialogueOpenedPacket(this, false));
        }
    }

    public final void setPage(int index) {
        if (index == this.dialogueReference.getPages().size()) {
            this.close();
            return;
        }
        if (index < 0 || index > this.dialogueReference.getPages().size()) {
            Cobblemon.LOGGER.error("Dialogue requested page " + index + " but it doesn't exist");
            return;
        }
        this.setPage(this.dialogueReference.getPages().get(index));
    }

    @NotNull
    public final MoStruct toMoLangStruct() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"current_page", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$0(this, arg_0)), TuplesKt.to((Object)"current_page_number", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$1(this, arg_0)), TuplesKt.to((Object)"next_page", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$2(this, arg_0)), TuplesKt.to((Object)"set_page", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$3(this, arg_0)), TuplesKt.to((Object)"close", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$4(this, arg_0)), TuplesKt.to((Object)"input", arg_0 -> ActiveDialogue.toMoLangStruct$lambda$5(this, arg_0))};
        return MoLangFunctions.INSTANCE.addStandardFunctions(new QueryStruct(MapsKt.hashMapOf((Pair[])pairArray)));
    }

    public final void close() {
        if (this.initialized) {
            DialogueManager.stopDialogue(this.playerEntity);
        }
        this.completion.complete(Unit.INSTANCE);
    }

    public final void escape() {
        DialogueAction dialogueAction = this.currentPage.getEscapeAction();
        if (dialogueAction == null) {
            dialogueAction = this.dialogueReference.getEscapeAction();
        }
        DialogueAction action = dialogueAction;
        action.invoke(this, null);
    }

    private static final Object initialize$lambda$0(ActiveDialogue this$0, MoParams moParams) {
        Intrinsics.checkNotNullParameter((Object)moParams, (String)"<unused var>");
        return this$0.toMoLangStruct();
    }

    private static final Object initialize$lambda$1(ActiveDialogue this$0, MoParams moParams) {
        Intrinsics.checkNotNullParameter((Object)moParams, (String)"<unused var>");
        return this$0.playerStruct;
    }

    private static final Unit setPage$lambda$1(UUID $inputId, ActiveDialogue this$0) {
        block0: {
            Object object;
            if (!Intrinsics.areEqual((Object)$inputId, (Object)this$0.activeInput.getInputId()) || !this$0.isActive() || (object = this$0.activeInput.getDialogueInput().getTimeout()) == null || (object = ((DialogueTimeout)object).getAction()) == null) break block0;
            object.invoke(this$0, null);
        }
        return Unit.INSTANCE;
    }

    private static final Object toMoLangStruct$lambda$0(ActiveDialogue this$0, MoParams moParams) {
        return this$0.currentPage.toMoLangStruct(this$0);
    }

    private static final Object toMoLangStruct$lambda$1(ActiveDialogue this$0, MoParams moParams) {
        return new DoubleValue(this$0.getCurrentPageIndex());
    }

    private static final Unit toMoLangStruct$lambda$2(ActiveDialogue this$0, MoParams moParams) {
        this$0.incrementPage();
        return Unit.INSTANCE;
    }

    private static final Unit toMoLangStruct$lambda$3(ActiveDialogue this$0, MoParams args) {
        Object t = args.get(0);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this$0.setPage((MoValue)t);
        return Unit.INSTANCE;
    }

    private static final Unit toMoLangStruct$lambda$4(ActiveDialogue this$0, MoParams moParams) {
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit toMoLangStruct$lambda$5(ActiveDialogue this$0, MoParams params) {
        ActiveInput activeInput = this$0.activeInput;
        String string = params.getParams().size() > 0 ? params.get(0).asString() : "";
        Intrinsics.checkNotNull((Object)string);
        activeInput.handle(string);
        return Unit.INSTANCE;
    }
}

