/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.data;

import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.util.IdentifierExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u000eH&\u00a2\u0006\u0004\b\u0006\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00158&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00198&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "T", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "", "reload", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Ljava/io/BufferedReader;", "reader", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "parse", "(Ljava/io/BufferedReader;Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", "", "data", "(Ljava/util/Map;)V", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "typeToken", "", "getResourcePath", "()Ljava/lang/String;", "resourcePath", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nJsonDataRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonDataRegistry.kt\ncom/cobblemon/mod/common/api/data/JsonDataRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n216#2,2:84\n*S KotlinDebug\n*F\n+ 1 JsonDataRegistry.kt\ncom/cobblemon/mod/common/api/data/JsonDataRegistry\n*L\n49#1:84,2\n*E\n"})
public interface JsonDataRegistry<T>
extends DataRegistry {
    @NotNull
    public static final Companion Companion = com.cobblemon.mod.common.api.data.JsonDataRegistry$Companion.$$INSTANCE;
    @NotNull
    public static final String JSON_EXTENSION = ".json";

    @NotNull
    public Gson getGson();

    @NotNull
    public TypeToken<T> getTypeToken();

    @NotNull
    public String getResourcePath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void reload(@NotNull ResourceManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        HashMap data = new HashMap();
        Map map = manager.listResources(this.getResourcePath(), JsonDataRegistry::reload$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"listResources(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            if (Intrinsics.areEqual((Object)identifier2.getNamespace(), (Object)"pixelmon")) continue;
            Closeable closeable = resource.open();
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)stream);
                Closeable closeable2 = stream;
                Object object = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)closeable2, (Charset)object);
                int n = 8192;
                closeable2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object = null;
                try {
                    BufferedReader reader2 = (BufferedReader)closeable2;
                    boolean bl3 = false;
                    ResourceLocation resolvedIdentifier = ResourceLocation.fromNamespaceAndPath((String)identifier2.getNamespace(), (String)FilesKt.getNameWithoutExtension((File)new File(identifier2.getPath())));
                    Map map2 = data;
                    Intrinsics.checkNotNull((Object)resolvedIdentifier);
                    map2.put(resolvedIdentifier, this.parse(reader2, resolvedIdentifier));
                    reader = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.reload(data);
    }

    default public T parse(@NotNull BufferedReader reader, @NotNull ResourceLocation identifier2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        try {
            object = this.getGson().fromJson((Reader)reader, this.getTypeToken().getType());
        }
        catch (Exception exception) {
            throw new ExecutionException("Error loading JSON for data: " + identifier2, exception);
        }
        return (T)object;
    }

    public void reload(@NotNull Map<ResourceLocation, ? extends T> var1);

    private static boolean reload$lambda$0(ResourceLocation path) {
        Intrinsics.checkNotNull((Object)path);
        return IdentifierExtensionsKt.endsWith(path, JSON_EXTENSION);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/api/data/JsonDataRegistry$Companion;", "", "<init>", "()V", "", "JSON_EXTENSION", "Ljava/lang/String;", "common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String JSON_EXTENSION = ".json";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static <T> void reload(@NotNull JsonDataRegistry<T> $this, @NotNull ResourceManager manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            ((JsonDataRegistry)$this).reload(manager);
        }

        @Deprecated
        public static <T> T parse(@NotNull JsonDataRegistry<T> $this, @NotNull BufferedReader reader, @NotNull ResourceLocation identifier2) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            return (T)((JsonDataRegistry)$this).parse(reader, identifier2);
        }
    }
}

