/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.battles.model.actor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.exception.IllegalActionChoiceException;
import com.cobblemon.mod.common.net.messages.client.battle.BattleFaintPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleHealthChangePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattlePersistentStatusPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleReplacePokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleSwapPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleSwitchPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Ljava/util/UUID;", "gameId", "", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemonList", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "battleAI", "<init>", "(Ljava/util/UUID;Ljava/util/List;Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;)V", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "onChoiceRequested", "()V", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "getBattleAI", "()Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "common"})
@SourceDebugExtension(value={"SMAP\nAIBattleActor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIBattleActor.kt\ncom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1869#2,2:85\n*S KotlinDebug\n*F\n+ 1 AIBattleActor.kt\ncom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor\n*L\n57#1:85,2\n*E\n"})
public abstract class AIBattleActor
extends BattleActor {
    @NotNull
    private final BattleAI battleAI;

    public AIBattleActor(@NotNull UUID gameId, @NotNull List<? extends BattlePokemon> pokemonList, @NotNull BattleAI battleAI) {
        Intrinsics.checkNotNullParameter((Object)gameId, (String)"gameId");
        Intrinsics.checkNotNullParameter(pokemonList, (String)"pokemonList");
        Intrinsics.checkNotNullParameter((Object)battleAI, (String)"battleAI");
        super(gameId, CollectionsKt.toMutableList((Collection)pokemonList));
        this.battleAI = battleAI;
    }

    @NotNull
    public final BattleAI getBattleAI() {
        return this.battleAI;
    }

    @Override
    public void sendUpdate(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        super.sendUpdate(packet);
        NetworkPacket<?> networkPacket = packet;
        if (networkPacket instanceof BattleMakeChoicePacket) {
            this.onChoiceRequested();
        } else if (!(networkPacket instanceof BattlePersistentStatusPacket) && !(networkPacket instanceof BattleFaintPacket)) {
            if (networkPacket instanceof BattleSwitchPokemonPacket) {
                if (!((BattleSwitchPokemonPacket)packet).isAlly()) {
                    // empty if block
                }
            } else if (!(networkPacket instanceof BattleSwapPokemonPacket)) {
                if (networkPacket instanceof BattleHealthChangePacket) {
                    this.battleAI.onHealthChange((BattleHealthChangePacket)packet);
                } else if (networkPacket instanceof BattleTransformPokemonPacket ? !((BattleTransformPokemonPacket)packet).isAlly() : !(networkPacket instanceof BattleReplacePokemonPacket) || !((BattleReplacePokemonPacket)packet).isAlly()) {
                    // empty if block
                }
            }
        }
    }

    public void onChoiceRequested() {
        try {
            ShowdownActionRequest showdownActionRequest = this.getRequest();
            if (showdownActionRequest != null) {
                ShowdownActionRequest it = showdownActionRequest;
                boolean bl = false;
                this.setActionResponses(it.iterate(this.getActivePokemon(), (arg_0, arg_1, arg_2) -> AIBattleActor.onChoiceRequested$lambda$0$0(this, arg_0, arg_1, arg_2)));
                Iterable $this$forEach$iv = this.getPokemonList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BattlePokemon pokemon = (BattlePokemon)element$iv;
                    boolean bl2 = false;
                    pokemon.setWillBeSwitchedIn(false);
                }
            } else {
                Function0 cfr_ignored_0 = () -> AIBattleActor.onChoiceRequested$lambda$1(this);
            }
        }
        catch (IllegalActionChoiceException exception) {
            Cobblemon.LOGGER.error("AI was unable to choose an action, we're going to need to pass!");
            exception.printStackTrace();
            ShowdownActionRequest showdownActionRequest = this.getRequest();
            if (showdownActionRequest != null) {
                ShowdownActionRequest it = showdownActionRequest;
                boolean bl = false;
                this.setActionResponses(it.iterate(this.getActivePokemon(), AIBattleActor::onChoiceRequested$lambda$2$0));
            }
            Function0 cfr_ignored_1 = () -> AIBattleActor.onChoiceRequested$lambda$3(this);
        }
    }

    private static final ShowdownActionResponse onChoiceRequested$lambda$0$0(AIBattleActor this$0, ActiveBattlePokemon battleMon, ShowdownMoveset moveset, boolean forceSwitch) {
        Intrinsics.checkNotNullParameter((Object)battleMon, (String)"battleMon");
        return this$0.battleAI.choose(battleMon, this$0.getBattle(), this$0.getSide(), moveset, forceSwitch);
    }

    private static final Unit onChoiceRequested$lambda$1(AIBattleActor this$0) {
        List response = new ArrayList();
        int n = this$0.getActivePokemon().size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            response.add(PassActionResponse.INSTANCE);
        }
        this$0.setActionResponses(response);
        Cobblemon.LOGGER.warn("AI requested choice, but no request was set. Returning PassActionResponses.");
        return Unit.INSTANCE;
    }

    private static final PassActionResponse onChoiceRequested$lambda$2$0(ActiveBattlePokemon activeBattlePokemon, ShowdownMoveset showdownMoveset, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"<unused var>");
        return PassActionResponse.INSTANCE;
    }

    private static final Unit onChoiceRequested$lambda$3(AIBattleActor this$0) {
        List response = new ArrayList();
        int n = this$0.getActivePokemon().size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            response.add(PassActionResponse.INSTANCE);
        }
        this$0.setActionResponses(response);
        return Unit.INSTANCE;
    }
}

