/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/CountFollowersTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "checkTicks", "Lcom/mojang/datafixers/util/Either;", "getCheckTicks", "()Lcom/mojang/datafixers/util/Either;", "common"})
public final class CountFollowersTaskConfig
implements SingleTaskConfig {
    @NotNull
    private final Either<Expression, MoLangConfigVariable> checkTicks;

    public CountFollowersTaskConfig() {
        Either either = Either.left((Object)MoLangExtensionsKt.asExpression("10"));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
        this.checkTicks = either;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getCheckTicks() {
        return this.checkTicks;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf(this.checkTicks));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        int checkTicksValue = this.resolveInt(this.checkTicks, behaviourConfigurationContext.getRuntime());
        MemoryModuleType[] memoryModuleTypeArray = new MemoryModuleType[3];
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (String)"NEAREST_VISIBLE_LIVING_ENTITIES");
        memoryModuleTypeArray[1] = CobblemonMemories.HERD_SIZE;
        memoryModuleTypeArray[2] = CobblemonMemories.HERD_LEADER;
        behaviourConfigurationContext.addMemories(memoryModuleTypeArray);
        memoryModuleTypeArray = new SensorType[1];
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.NEAREST_LIVING_ENTITIES, (String)"NEAREST_LIVING_ENTITIES");
        behaviourConfigurationContext.addSensors((SensorType<?>[])memoryModuleTypeArray);
        return (BehaviorControl)BehaviorBuilder.create(arg_0 -> CountFollowersTaskConfig.createTask$lambda$0(checkTicksValue, arg_0));
    }

    private static final App createTask$lambda$0(int $checkTicksValue, BehaviorBuilder.Instance instance) {
        return instance.group((App)instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES), (App)instance.registered(CobblemonMemories.HERD_SIZE)).apply((Applicative)instance, (arg_0, arg_1) -> CountFollowersTaskConfig.createTask$lambda$0$0($checkTicksValue, instance, arg_0, arg_1));
    }

    private static final Trigger createTask$lambda$0$0(int $checkTicksValue, BehaviorBuilder.Instance $instance, MemoryAccessor nearbyEntities, MemoryAccessor herdCount) {
        return (arg_0, arg_1, arg_2) -> CountFollowersTaskConfig.createTask$lambda$0$0$0($checkTicksValue, $instance, nearbyEntities, herdCount, arg_0, arg_1, arg_2);
    }

    private static final boolean createTask$lambda$0$0$0(int $checkTicksValue, BehaviorBuilder.Instance $instance, MemoryAccessor $nearbyEntities, MemoryAccessor $herdCount, ServerLevel world, LivingEntity entity, long l) {
        if (world.getGameTime() % (long)$checkTicksValue != 0L) {
            return false;
        }
        String string = entity.getUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String myUUID = string;
        Iterable iterable = ((NearestVisibleLivingEntities)$instance.get($nearbyEntities)).findAll(arg_0 -> CountFollowersTaskConfig.createTask$lambda$0$0$0$0(myUUID, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAll(...)");
        int followersCount = CollectionsKt.count((Iterable)iterable);
        if (followersCount == 0) {
            $herdCount.erase();
        } else {
            $herdCount.set((Object)followersCount);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createTask$lambda$0$0$0$0(String $myUUID, LivingEntity it) {
        if (!(it instanceof PokemonEntity)) return false;
        if (!((PokemonEntity)it).getBrain().hasMemoryValue(CobblemonMemories.HERD_LEADER)) return false;
        Optional optional = ((PokemonEntity)it).getBrain().getMemory(CobblemonMemories.HERD_LEADER);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getMemory(...)");
        if (!Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), (Object)$myUUID)) return false;
        return true;
    }
}

