/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.advancement.criterion;

import com.cobblemon.mod.common.advancement.criterion.SimpleCriterionCondition;
import com.cobblemon.mod.common.advancement.criterion.TradePokemonContext;
import com.cobblemon.mod.common.advancement.criterion.TradePokemonCriterion;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B5\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\n\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/TradePokemonCriterion;", "Lcom/cobblemon/mod/common/advancement/criterion/SimpleCriterionCondition;", "Lcom/cobblemon/mod/common/advancement/criterion/TradePokemonContext;", "Ljava/util/Optional;", "Lnet/minecraft/advancements/critereon/ContextAwarePredicate;", "playerCtx", "", "traded", "received", "tradedHeldItem", "receivedHeldItem", "<init>", "(Ljava/util/Optional;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "context", "", "matches", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/advancement/criterion/TradePokemonContext;)Z", "Ljava/lang/String;", "getTraded", "()Ljava/lang/String;", "getReceived", "getTradedHeldItem", "getReceivedHeldItem", "Companion", "common"})
public final class TradePokemonCriterion
extends SimpleCriterionCondition<TradePokemonContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String traded;
    @NotNull
    private final String received;
    @NotNull
    private final String tradedHeldItem;
    @NotNull
    private final String receivedHeldItem;
    @NotNull
    private static final Codec<TradePokemonCriterion> CODEC;

    public TradePokemonCriterion(@NotNull Optional<ContextAwarePredicate> playerCtx, @NotNull String traded, @NotNull String received, @NotNull String tradedHeldItem, @NotNull String receivedHeldItem) {
        Intrinsics.checkNotNullParameter(playerCtx, (String)"playerCtx");
        Intrinsics.checkNotNullParameter((Object)traded, (String)"traded");
        Intrinsics.checkNotNullParameter((Object)received, (String)"received");
        Intrinsics.checkNotNullParameter((Object)tradedHeldItem, (String)"tradedHeldItem");
        Intrinsics.checkNotNullParameter((Object)receivedHeldItem, (String)"receivedHeldItem");
        super(playerCtx);
        this.traded = traded;
        this.received = received;
        this.tradedHeldItem = tradedHeldItem;
        this.receivedHeldItem = receivedHeldItem;
    }

    @NotNull
    public final String getTraded() {
        return this.traded;
    }

    @NotNull
    public final String getReceived() {
        return this.received;
    }

    @NotNull
    public final String getTradedHeldItem() {
        return this.tradedHeldItem;
    }

    @NotNull
    public final String getReceivedHeldItem() {
        return this.receivedHeldItem;
    }

    @Override
    public boolean matches(@NotNull ServerPlayer player, @NotNull TradePokemonContext context) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ResourceLocation heldItem1 = context.getTraded().heldItem().getItem().builtInRegistryHolder().key().location();
        ResourceLocation heldItem2 = context.getReceived().heldItem().getItem().builtInRegistryHolder().key().location();
        if (!Intrinsics.areEqual((Object)this.traded, (Object)"any") && !Intrinsics.areEqual((Object)context.getTraded().getSpecies().getResourceIdentifier(), (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(this.traded, null, 1, null))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.received, (Object)"any") && !Intrinsics.areEqual((Object)context.getReceived().getSpecies().getResourceIdentifier(), (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(this.received, null, 1, null))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)heldItem1, (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(this.tradedHeldItem, null, 1, null)) && !Intrinsics.areEqual((Object)heldItem1, (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default("minecraft:air", null, 1, null))) {
            return false;
        }
        return Intrinsics.areEqual((Object)heldItem2, (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(this.receivedHeldItem, null, 1, null)) || Intrinsics.areEqual((Object)heldItem2, (Object)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default("minecraft:air", null, 1, null));
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(arg_0 -> TradePokemonCriterion.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("traded", (Object)"any").forGetter(arg_0 -> TradePokemonCriterion.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("received", (Object)"any").forGetter(arg_0 -> TradePokemonCriterion.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("traded_held_item", (Object)"minecraft:air").forGetter(arg_0 -> TradePokemonCriterion.CODEC$lambda$0$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("received_held_item", (Object)"minecraft:air").forGetter(arg_0 -> TradePokemonCriterion.CODEC$lambda$0$4((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)it, TradePokemonCriterion::new);
    }

    private static final Optional CODEC$lambda$0$0(KProperty1 $tmp0, TradePokemonCriterion p0) {
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$0$1(KProperty1 $tmp0, TradePokemonCriterion p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$0$2(KProperty1 $tmp0, TradePokemonCriterion p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$0$3(KProperty1 $tmp0, TradePokemonCriterion p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$0$4(KProperty1 $tmp0, TradePokemonCriterion p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Codec codec = RecordCodecBuilder.create(TradePokemonCriterion::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/TradePokemonCriterion$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/advancement/criterion/TradePokemonCriterion;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<TradePokemonCriterion> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

