/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.runtime;

import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.struct.MoStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import com.bedrockk.molang.runtime.value.StringValue;
import java.util.ArrayList;
import java.util.List;

public class MoParams {
    public static final MoParams EMPTY = new MoParams(new MoLangEnvironment(), new ArrayList<MoValue>());
    private final MoLangEnvironment environment;
    private final List<MoValue> params;

    public MoParams(MoLangEnvironment environment, List<MoValue> params) {
        this.environment = environment;
        this.params = params;
    }

    public <T extends MoValue> T get(int index) {
        return (T)this.params.get(index);
    }

    public boolean contains(int index) {
        return this.params.size() >= index + 1;
    }

    public int getInt(int index) {
        return (int)this.getDouble(index);
    }

    public double getDouble(int index) {
        return ((DoubleValue)this.get(index)).asDouble();
    }

    public MoStruct getStruct(int index) {
        return (MoStruct)this.get(index);
    }

    public String getString(int index) {
        return ((StringValue)this.get(index)).asString();
    }

    public MoLangEnvironment getEnv(int index) {
        return (MoLangEnvironment)this.get(index);
    }

    public MoLangEnvironment getEnvironment() {
        return this.environment;
    }

    public List<MoValue> getParams() {
        return this.params;
    }
}

