/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.ast;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.StringHolder;
import com.bedrockk.molang.ast.NameExpression;
import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.MoScope;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.ArrayList;
import java.util.Collections;

public final class ArrayAccessExpression
extends StringHolder
implements Expression {
    private final Expression array;
    private final Expression index;

    @Override
    public MoValue evaluate(MoScope scope, MoLangEnvironment environment) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.array instanceof NameExpression) {
            names.addAll(((NameExpression)this.array).getNames());
        } else {
            Collections.addAll(names, this.array.evaluate(scope, environment).asString().split("\\."));
        }
        names.add(String.valueOf((int)this.index.evaluate(scope, environment).asDouble()));
        return environment.getValue(names.iterator());
    }

    @Override
    public void assign(MoScope scope, MoLangEnvironment environment, MoValue value) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.array instanceof NameExpression) {
            names.addAll(((NameExpression)this.array).getNames());
        } else {
            Collections.addAll(names, this.array.evaluate(scope, environment).asString().split("\\."));
        }
        names.add(String.valueOf((int)this.index.evaluate(scope, environment).asDouble()));
        environment.setValue(names.iterator(), value);
    }

    public ArrayAccessExpression(Expression array, Expression index) {
        this.array = array;
        this.index = index;
    }

    public Expression getArray() {
        return this.array;
    }

    public Expression getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayAccessExpression)) {
            return false;
        }
        ArrayAccessExpression other = (ArrayAccessExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$array = this.getArray();
        Expression other$array = other.getArray();
        if (this$array == null ? other$array != null : !this$array.equals(other$array)) {
            return false;
        }
        Expression this$index = this.getIndex();
        Expression other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayAccessExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $array = this.getArray();
        result = result * 59 + ($array == null ? 43 : $array.hashCode());
        Expression $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    public String toString() {
        return "ArrayAccessExpression(array=" + this.getArray() + ", index=" + this.getIndex() + ")";
    }
}

