/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils.explosion;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FOFExplosion
extends Explosion {
    protected static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    protected final boolean fire;
    protected final Explosion.BlockInteraction blockInteraction;
    protected final RandomSource random = RandomSource.create();
    protected final Level level;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final PokemonEntity pokemon;
    protected final boolean shouldHurtAlly;
    @Nullable
    public final Entity source;
    public final float radius;
    protected final DamageSource damageSource;
    protected final ExplosionDamageCalculator damageCalculator;
    protected final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    protected final Map<Player, Vec3> hitPlayers = Maps.newHashMap();

    public FOFExplosion(Level level, @Nullable Entity source, PokemonEntity pokemon, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction, null, null, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.level = level;
        this.source = source;
        this.radius = radius + this.pokemonExplosionBaseValue(isProjectileExplosion);
        this.x = toBlowX;
        this.y = toBlowY;
        this.z = toBlowZ;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.damageSource = damageSource == null ? level.damageSources().generic() : damageSource;
        this.damageCalculator = damageCalculator == null ? this.makeDamageCalculator(source) : damageCalculator;
        this.pokemon = pokemon;
        this.shouldHurtAlly = shouldHurtAlly;
    }

    protected ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public static Optional<Float> getBlockExplosionResistance(BlockState state, FluidState fluid) {
        return state.isAir() && fluid.isEmpty() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(state.getBlock().getExplosionResistance(), fluid.getExplosionResistance())));
    }

    public void explode() {
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d = (float)j / 15.0f * 2.0f - 1.0f;
                    double e = (float)k / 15.0f * 2.0f - 1.0f;
                    double f = (float)l / 15.0f * 2.0f - 1.0f;
                    double g = Math.sqrt(d * d + e * e + f * f);
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = this.x;
                    double n = this.y;
                    double o = this.z;
                    float p = 0.3f;
                    for (float h = this.radius * (0.8f + this.level.random.nextFloat() * 0.2f); h > 0.0f; h -= 0.22500001f) {
                        BlockPos blockPos = BlockPos.containing((double)m, (double)n, (double)o);
                        BlockState blockState = this.level.getBlockState(blockPos);
                        FluidState fluidState = this.level.getFluidState(blockPos);
                        if (!this.level.isInWorldBounds(blockPos)) continue block2;
                        Optional<Float> optional = FOFExplosion.getBlockExplosionResistance(blockState, fluidState);
                        if (optional.isPresent()) {
                            h -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f) {
                            set.add(blockPos);
                        }
                        m += d * 0.3;
                        n += e * 0.3;
                        o += f * 0.3;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        PokemonAttackEffect.dealAoEDamage(this.pokemon, this.source, this.shouldHurtAlly, false);
    }

    public void finalizeExplosion(boolean spawnParticles) {
        this.finalizeExplosion();
    }

    public void finalizeExplosion() {
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        } else {
            this.level.playSound(null, this.x, this.y, this.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
        }
        boolean bl = this.interactsWithBlocks();
        SimpleParticleType particleType = !(this.radius < 2.0f) ? ParticleTypes.EXPLOSION_EMITTER : ParticleTypes.EXPLOSION;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)particleType, this.x, this.y, this.z, 1, 1.0, 0.0, 0.0, 1.0);
        }
        if (bl) {
            ArrayList list = new ArrayList();
            Util.shuffle(this.toBlow, (RandomSource)this.level.random);
            for (BlockPos blockPos : this.toBlow) {
                this.level.getBlockState(blockPos).onExplosionHit(this.level, blockPos, (Explosion)this, (itemStack, blockPosx) -> FOFExplosion.addOrAppendStack(list, itemStack, blockPosx));
            }
            for (Pair pair : list) {
                Block.popResource((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.level.getProfiler().pop();
            for (Pair pair : list) {
                Block.popResource((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockPos3 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(blockPos3).isAir() || !this.level.getBlockState(blockPos3.below()).isSolidRender((BlockGetter)this.level, blockPos3.below())) continue;
                this.level.setBlockAndUpdate(blockPos3, BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)blockPos3));
            }
        }
    }

    public boolean interactsWithBlocks() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    public static FOFExplosion createExplosion(Entity source, PokemonEntity pokemonEntity, double x, double y, double z, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.warn("trying to create a new FOFExplosion without PokemonEntity");
            return null;
        }
        float radius = FOFExplosion.calculateRadius(pokemonEntity);
        ElementalType type1 = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType type2 = pokemonEntity.getPokemon().getSecondaryType();
        boolean shouldCreateFire = CobblemonFightOrFlight.moveConfig().should_create_fire && (type1.equals(ElementalTypes.FIRE) || type2 != null && type2.equals(ElementalTypes.FIRE));
        Explosion.BlockInteraction blockInteraction1 = CobblemonFightOrFlight.moveConfig().pokemon_griefing ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.KEEP;
        return new FOFExplosion(source.level(), source, pokemonEntity, source.damageSources().explosion((Entity)pokemonEntity, (Entity)pokemonEntity), null, x, y, z, radius, shouldCreateFire, blockInteraction1, shouldHurtAlly, isProjectileExplosion);
    }

    protected static float calculateRadius(PokemonEntity pokemonEntity) {
        Move move;
        Move move2 = move = PokemonUtils.shouldShoot(pokemonEntity) ? PokemonUtils.getRangeAttackMove(pokemonEntity) : PokemonUtils.getMeleeMove(pokemonEntity);
        if (move == null) {
            return 0.0f;
        }
        return PokemonAttackEffect.getAoERadius(pokemonEntity, move);
    }

    protected float pokemonExplosionBaseValue(boolean isProjectileExplosion) {
        return isProjectileExplosion ? 0.0f : 5.0f;
    }

    protected static void addOrAppendStack(List<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        for (int i = 0; i < drops.size(); ++i) {
            Pair<ItemStack, BlockPos> pair = drops.get(i);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable((ItemStack)itemStack, (ItemStack)stack)) continue;
            drops.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)ItemEntity.merge((ItemStack)itemStack, (ItemStack)stack, (int)16), (Object)((BlockPos)pair.getSecond())));
            if (!stack.isEmpty()) continue;
            return;
        }
        drops.add((Pair<ItemStack, BlockPos>)Pair.of((Object)stack, (Object)pos));
    }
}

