/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.net.messages.client.effect.RunPosableMoLangPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.pokemon.evolution.progress.UseMoveEvolutionProgress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PokemonUtils {
    private static final Map<String, PokeStaffComponent.CMDMODE> CMDMODE_IDS = Arrays.stream(PokeStaffComponent.CMDMODE.values()).collect(Collectors.toMap($ -> $.name().toLowerCase(), $ -> $));

    public static boolean shouldMelee(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getAttackMode() == 1;
    }

    public static boolean shouldShoot(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getAttackMode() == 2;
    }

    public static boolean shouldFightTarget(PokemonEntity pokemonEntity) {
        if (pokemonEntity.getPokemon().getLevel() < CobblemonFightOrFlight.commonConfig().minimum_attack_level) {
            return false;
        }
        LivingEntity owner = pokemonEntity.getOwner();
        if (owner != null) {
            PokemonEntity targetPokemon;
            LivingEntity targetOwner;
            if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner || PokemonUtils.getTarget(pokemonEntity) == null || PokemonUtils.getTarget(pokemonEntity) == owner || pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
                return false;
            }
            LivingEntity livingEntity = PokemonUtils.getTarget(pokemonEntity);
            if (livingEntity instanceof PokemonEntity && (targetOwner = (targetPokemon = (PokemonEntity)livingEntity).getOwner()) != null && (targetOwner == owner || !CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_player_pokemon)) {
                return false;
            }
            if (PokemonUtils.getTarget(pokemonEntity) instanceof Player && !CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_players) {
                return false;
            }
        } else {
            LivingEntity targetEntity = PokemonUtils.getTarget(pokemonEntity);
            if (targetEntity != null) {
                if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) <= 0.0) {
                    return false;
                }
                if (pokemonEntity.distanceToSqr((Entity)targetEntity) > 400.0) {
                    return false;
                }
            }
        }
        return !pokemonEntity.isBusy();
    }

    public static Set<MoveTemplate> getAllLearnableMoveTemplates(Pokemon pokemon) {
        HashSet<MoveTemplate> moves = new HashSet<MoveTemplate>();
        for (BenchedMove move : pokemon.getBenchedMoves()) {
            moves.add(move.getMoveTemplate());
        }
        moves.addAll(pokemon.getForm().getMoves().getLevelUpMovesUpTo(100));
        moves.addAll(pokemon.getForm().getMoves().getEvolutionMoves());
        moves.addAll(pokemon.getForm().getMoves().getTmMoves());
        moves.addAll(pokemon.getForm().getMoves().getTutorMoves());
        moves.addAll(pokemon.getForm().getMoves().getEggMoves());
        return moves;
    }

    public static boolean hasType(PokemonEntity pokemonEntity, ElementalType type) {
        return PokemonUtils.hasType(pokemonEntity.getPokemon(), type);
    }

    public static boolean hasType(Pokemon pokemon, ElementalType type) {
        ElementalType type2;
        ElementalType type1 = pokemon.getPrimaryType();
        if (type1 != type && (type2 = pokemon.getSecondaryType()) != null) {
            return type2 == type;
        }
        return true;
    }

    public static Move getMove(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.info("PokemonEntity is null");
            return null;
        }
        Move firstMove = pokemonEntity.getPokemon().getMoveSet().get(0);
        String moveName = "";
        if (!((PokemonInterface)pokemonEntity).getCurrentMove().isEmpty()) {
            moveName = ((PokemonInterface)pokemonEntity).getCurrentMove();
        } else if (firstMove != null) {
            moveName = firstMove.getName();
        }
        Move move = PokemonUtils.findMove(pokemonEntity, moveName);
        if (move == null && !pokemonEntity.level().isClientSide) {
            CobblemonFightOrFlight.LOGGER.warn("Can't get the move/Trying to return a null move. Move name:{}", (Object)moveName);
        }
        return move;
    }

    public static Move findMove(PokemonEntity pokemonEntity, String moveName) {
        Move move = null;
        boolean flag = false;
        if (!moveName.isEmpty()) {
            for (MoveTemplate m : PokemonUtils.getAllLearnableMoveTemplates(pokemonEntity.getPokemon())) {
                move = m.create();
                if (!m.getName().equals(moveName)) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            move = pokemonEntity.getPokemon().getMoveSet().get(0);
        }
        return move;
    }

    public static boolean isMeleeAttackMove(Move move) {
        if (move == null) {
            return false;
        }
        String moveName = move.getName();
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        boolean isPhysical = PokemonUtils.isPhysicalMove(move);
        boolean b1 = isPhysical && !Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) && !Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName) && !Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName);
        boolean b2 = isSpecial && Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static boolean isRangeAttackMove(Move move) {
        if (move == null) {
            return false;
        }
        String moveName = move.getName();
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        boolean isPhysical = PokemonUtils.isPhysicalMove(move);
        boolean b1 = isPhysical && (Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) || Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName) || Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName));
        boolean b2 = isSpecial && !Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static Move getMeleeMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isMeleeAttackMove(move)) {
            return move;
        }
        return null;
    }

    public static Move getRangeAttackMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isRangeAttackMove(move)) {
            return move;
        }
        return null;
    }

    public static Move getStatusMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        boolean b = PokemonUtils.isStatusMove(move);
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().self_targeting_status_move).toList().contains(move.getName());
        boolean b2 = MoveData.moveData.containsKey(move.getName());
        if (b && (b1 || b2)) {
            ((PokemonInterface)pokemonEntity).setCurrentMove(move);
            return move;
        }
        return null;
    }

    public static boolean findMoveEffectData(String effect) {
        List<MoveData> l = MoveData.moveData.get(effect);
        if (l != null) {
            for (MoveData data : l) {
                if (!Objects.equals(data.getName(), effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSpecialMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getSPECIAL());
    }

    public static boolean isPhysicalMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getPHYSICAL());
    }

    public static boolean isStatusMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getSTATUS());
    }

    public static void makeParticle(int particleAmount, Entity entity, SimpleParticleType particleType) {
        Level level = entity.level();
        if (particleAmount > 0) {
            double d = 0.0;
            double e = 0.0;
            double f = 0.0;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)particleType, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), particleAmount, d, e, f, 1.0);
            } else {
                for (int j = 0; j < particleAmount; ++j) {
                    level.addParticle((ParticleOptions)particleType, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), d, e, f);
                }
            }
        }
    }

    public static void setHurtByPlayer(PokemonEntity pokemonEntity, Entity target) {
        LivingEntity owner = pokemonEntity.getOwner();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.setLastHurtByPlayer(player);
            }
        }
    }

    public static boolean canTaunt(PokemonEntity pokemonEntity) {
        if (!CobblemonFightOrFlight.moveConfig().taunt_moves_needed) {
            return true;
        }
        boolean result = false;
        MoveSet moveSet = pokemonEntity.getPokemon().getMoveSet();
        for (Move move : moveSet) {
            if (!Arrays.stream(CobblemonFightOrFlight.moveConfig().taunting_moves).toList().contains(move.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isExplosiveMove(String moveName) {
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(moveName);
    }

    public static void createSonicBoomParticle(PokemonEntity pokemonEntity, LivingEntity target) {
        if (target == null) {
            return;
        }
        float height = pokemonEntity.getEyeHeight();
        Vec3 vec1 = pokemonEntity.position().add(0.0, (double)height, 0.0);
        Vec3 vec2 = target.getEyePosition().subtract(vec1);
        Vec3 vec3 = vec2.normalize();
        for (int i = 1; i < Mth.floor((double)vec2.length()) + 1; ++i) {
            Vec3 vec4 = vec1.add(vec3.scale((double)i));
            Level level = target.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, vec4.x, vec4.y, vec4.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void sendAnimationPacket(PokemonEntity pokemonEntity, String mode) {
        if (!pokemonEntity.level().isClientSide) {
            PlayPosableAnimationPacket pkt = new PlayPosableAnimationPacket(pokemonEntity.getId(), Set.of(mode), List.of());
            pokemonEntity.level().getEntitiesOfClass(ServerPlayer.class, AABB.ofSize((Vec3)pokemonEntity.position(), (double)64.0, (double)64.0, (double)64.0), livingEntity -> true).forEach(arg_0 -> ((PlayPosableAnimationPacket)pkt).sendToPlayer(arg_0));
        }
    }

    public static void updateMoveEvolutionProgress(Pokemon pokemon, MoveTemplate move) {
        if (UseMoveEvolutionProgress.Companion.supports(pokemon, move) && CobblemonFightOrFlight.commonConfig().can_progress_use_move_evolution) {
            UseMoveEvolutionProgress progress = (UseMoveEvolutionProgress)pokemon.getEvolutionProxy().current().progressFirstOrCreate(evolutionProgress -> {
                if (evolutionProgress instanceof UseMoveEvolutionProgress) {
                    UseMoveEvolutionProgress umep = (UseMoveEvolutionProgress)evolutionProgress;
                    return umep.currentProgress().getMove().equals(move);
                }
                return false;
            }, UseMoveEvolutionProgress::new);
            progress.updateProgress(new UseMoveEvolutionProgress.Progress(move, progress.currentProgress().getAmount() + 1));
        }
    }

    public static boolean shouldRetreat(PokemonEntity pokemonEntity) {
        return pokemonEntity.getOwner() != null && (double)pokemonEntity.getHealth() < (double)pokemonEntity.getMaxHealth() * 0.5 && Arrays.stream(CobblemonFightOrFlight.moveConfig().emergency_exit_like_abilities).toList().contains(pokemonEntity.getPokemon().getAbility().getName());
    }

    public static void makeCobblemonParticle(Entity entity, String particleName) {
        if (entity != null) {
            RunPosableMoLangPacket packet = new RunPosableMoLangPacket(entity.getId(), Set.of(String.format("q.particle('cobblemon:%s', 'target')", particleName)));
            packet.sendToPlayersAround(entity.getX(), entity.getY(), entity.getZ(), 50.0, entity.level().dimension(), serverPlayer -> false);
        }
    }

    public static ItemStack getHeldItem(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return null;
        }
        return PokemonUtils.getHeldItem(pokemonEntity.getPokemon());
    }

    public static ItemStack getHeldItem(Pokemon pokemon) {
        if (pokemon == null) {
            return null;
        }
        return pokemon.heldItem();
    }

    public static boolean isUsingNewHealthMechanic() {
        return CobblemonFightOrFlight.commonConfig().shouldOverrideHealthMechanic;
    }

    public static String getNatureName(PokemonEntity pokemonEntity) {
        return PokemonUtils.getNatureName(pokemonEntity.getPokemon());
    }

    public static String getNatureName(Pokemon pokemon) {
        return pokemon.getNature().getDisplayName().toLowerCase().replace("cobblemon.nature.", "");
    }

    public static int getMaxHealth(PokemonEntity pokemonEntity) {
        return PokemonUtils.getMaxHealth(pokemonEntity.getPokemon());
    }

    public static int getHPStat(Pokemon pokemon) {
        return pokemon.getMaxHealth();
    }

    public static int getMaxHealth(Pokemon pokemon) {
        int hpStat = PokemonUtils.getHPStat(pokemon);
        int minStat = CobblemonFightOrFlight.commonConfig().min_HP_required_stat;
        int midStat = CobblemonFightOrFlight.commonConfig().mid_HP_required_stat;
        int maxStat = CobblemonFightOrFlight.commonConfig().max_HP_required_stat;
        int stat = Mth.clamp((int)hpStat, (int)minStat, (int)maxStat);
        int minHealth = CobblemonFightOrFlight.commonConfig().min_HP;
        int midHealth = CobblemonFightOrFlight.commonConfig().mid_HP;
        int maxHealth = CobblemonFightOrFlight.commonConfig().max_HP;
        return Math.round(stat < midStat ? Mth.lerp((float)((float)(stat - minStat) / (float)(midStat - minStat)), (float)minHealth, (float)midHealth) : Mth.lerp((float)((float)(stat - midStat) / (float)(maxStat - midStat)), (float)midHealth, (float)maxHealth));
    }

    public static void entityHpToPokemonHp(PokemonEntity pokemonEntity, float amount, boolean isHealing) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.getCurrentHealth() == 0 || pokemonEntity.isBattling() || pokemonEntity.getOwner() == null && !CobblemonFightOrFlight.commonConfig().enable_health_sync_for_wild_pokemon) {
            return;
        }
        float ratio = amount / pokemonEntity.getMaxHealth();
        int val = pokemon.getCurrentHealth() + (int)Math.floor(ratio * (float)PokemonUtils.getHPStat(pokemon)) * (isHealing ? 1 : -1);
        pokemon.setCurrentHealth(val);
    }

    public static void taunt(PokemonEntity pokemonEntity) {
        LivingEntity livingEntity = pokemonEntity.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            List entities = pokemonEntity.level().getEntitiesOfClass(Mob.class, pokemonEntity.getBoundingBox().inflate(10.0, 2.0, 10.0), mob -> mob.getTarget() == player);
            for (Mob mob2 : entities) {
                mob2.setTarget((LivingEntity)pokemonEntity);
            }
        }
    }

    public static boolean isSheerForce(PokemonEntity pokemonEntity) {
        return PokemonUtils.abilityIs(pokemonEntity, "sheerforce");
    }

    public static boolean abilityIs(PokemonEntity pokemonEntity, String abilityName) {
        return pokemonEntity.getPokemon().getAbility().getName().equals(abilityName);
    }

    public static boolean canActivateSheerForce(PokemonEntity pokemonEntity) {
        Move move;
        if (pokemonEntity != null && PokemonUtils.isSheerForce(pokemonEntity) && (move = PokemonUtils.getMove(pokemonEntity)) != null && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.canActivateSheerForce()) continue;
                return true;
            }
        }
        return false;
    }

    public static PokeStaffComponent.CMDMODE getCommandMode(PokemonEntity pokemon) {
        if (!CobblemonFightOrFlight.commonConfig().can_use_poke_staff) {
            return PokeStaffComponent.CMDMODE.NOCMD;
        }
        return CMDMODE_IDS.getOrDefault(((PokemonInterface)pokemon).getCommand().toLowerCase(), PokeStaffComponent.CMDMODE.NOCMD);
    }

    public static boolean WildPokemonCanPerformUnprovokedAttack(PokemonEntity pokemonEntity) {
        return pokemonEntity != null && CobblemonFightOrFlight.commonConfig().do_pokemon_attack_unprovoked && !pokemonEntity.getPokemon().isPlayerOwned() && pokemonEntity.getPokemon().getLevel() >= CobblemonFightOrFlight.commonConfig().minimum_attack_unprovoked_level;
    }

    public static String getCommandData(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getCommandData();
    }

    public static boolean moveCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.getOwner() != null && PokeStaffComponent.CMDMODE.MOVE == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean moveAttackCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.getOwner() != null && PokeStaffComponent.CMDMODE.MOVE_ATTACK == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean stayCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.getOwner() != null && PokeStaffComponent.CMDMODE.STAY == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean attackPositionAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.getOwner() != null && PokeStaffComponent.CMDMODE.ATTACK_POSITION == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean shouldDisableFollowOwner(PokemonEntity pokemon) {
        if (pokemon.getOwner() == null) {
            return false;
        }
        PokeStaffComponent.CMDMODE cmd = PokemonUtils.getCommandMode(pokemon);
        switch (cmd) {
            case ATTACK: 
            case ATTACK_POSITION: 
            case MOVE_ATTACK: 
            case STAY: 
            case MOVE: {
                return true;
            }
        }
        return false;
    }

    public static void clearCommand(PokemonEntity pokemonEntity) {
        ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        ((PokemonInterface)pokemonEntity).setCommandData("");
    }

    public static void finishMoving(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stay_after_move_command) {
            if (PokemonUtils.moveCommandAvailable(pokemonEntity)) {
                ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.STAY.name());
            }
        } else {
            PokemonUtils.clearCommand(pokemonEntity);
        }
    }

    public static void pokemonEntityApproachPos(PokemonEntity pokemonEntity, BlockPos pos, double speedModifier) {
        if (pos != BlockPos.ZERO && pokemonEntity.getNavigation().isDone()) {
            pokemonEntity.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), speedModifier);
        }
    }

    public static float getAttackRadius() {
        return 16.0f;
    }

    public static boolean shouldStopRunningAfterHurt(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stop_running_after_hurt) {
            return pokemonEntity.getHealth() < pokemonEntity.getMaxHealth();
        }
        return false;
    }

    public static boolean pokemonTryForceEncounter(PokemonEntity attackingPokemon, Entity hurtTarget) {
        if (attackingPokemon == null || hurtTarget == null) {
            return false;
        }
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity defendingPokemon = (PokemonEntity)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (defendingPokemon.getPokemon().isPlayerOwned()) {
                    if (!(!CobblemonFightOrFlight.commonConfig().force_player_battle_on_pokemon_hurt || CobblemonFightOrFlight.commonConfig().force_player_battle_check_team && FOFUtils.teamCheck((LivingEntity)attackingPokemon, (LivingEntity)defendingPokemon))) {
                        return PokemonUtils.pokemonForceEncounterPvP(attackingPokemon, defendingPokemon);
                    }
                } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt) {
                    return PokemonUtils.pokemonForceEncounterPvE(attackingPokemon, defendingPokemon);
                }
            } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt && defendingPokemon.getPokemon().isPlayerOwned()) {
                return PokemonUtils.pokemonForceEncounterPvE(defendingPokemon, attackingPokemon);
            }
        } else if (hurtTarget instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (CobblemonFightOrFlight.commonConfig().force_player_battle_on_player_hurt) {
                    return PokemonUtils.pokemonForceEncounterPvP(player, attackingPokemon);
                }
            } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_player_hurt) {
                return PokemonUtils.pokemonForceEncounterPvE(player, attackingPokemon);
            }
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvP(PokemonEntity playerPokemon, PokemonEntity opponentPokemon) {
        LivingEntity livingEntity = playerPokemon.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            return PokemonUtils.pokemonForceEncounterPvP(serverPlayer, opponentPokemon);
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvP(ServerPlayer serverPlayer, PokemonEntity opponentPokemon) {
        LivingEntity livingEntity;
        if (serverPlayer != null && (livingEntity = opponentPokemon.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverOpponent = (ServerPlayer)livingEntity;
            if (serverPlayer == serverOpponent || !PokemonUtils.canBattlePlayer(serverPlayer) || !PokemonUtils.canBattlePlayer(serverOpponent)) {
                return false;
            }
            BattleBuilder.INSTANCE.pvp1v1(serverPlayer, serverOpponent, null, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false);
            return true;
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvE(ServerPlayer serverPlayer, PokemonEntity wildPokemon) {
        if (serverPlayer != null) {
            if (!PokemonUtils.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
            return true;
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvE(PokemonEntity playerPokemon, PokemonEntity wildPokemon) {
        LivingEntity livingEntity = playerPokemon.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (!PokemonUtils.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, playerPokemon.getPokemon().getUuid(), BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
            return true;
        }
        return false;
    }

    public static boolean canBattlePlayer(ServerPlayer serverPlayer) {
        boolean playerHasAlivePokemon = false;
        for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
            if (pokemon.isFainted()) continue;
            playerHasAlivePokemon = true;
            break;
        }
        return BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)serverPlayer) == null && playerHasAlivePokemon && serverPlayer.isAlive();
    }

    public static boolean shouldCheckPokeStaff() {
        return CobblemonFightOrFlight.commonConfig().should_check_poke_staff;
    }

    public static LivingEntity getTarget(PokemonEntity pokemonEntity) {
        Optional targetOpt = pokemonEntity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        return targetOpt.orElse(null);
    }

    public static float calculateExtraSpeed(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return 1.0f;
        }
        float minimum_movement_speed = CobblemonFightOrFlight.commonConfig().minimum_movement_speed;
        float maximum_movement_speed = CobblemonFightOrFlight.commonConfig().maximum_movement_speed;
        float speed_limit = CobblemonFightOrFlight.commonConfig().speed_stat_limit;
        float speed = pokemonEntity.getPokemon().getSpeed();
        return Mth.lerp((float)(speed / speed_limit), (float)minimum_movement_speed, (float)maximum_movement_speed);
    }
}

