/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.RayTrace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FOFUtils {
    public static Vec3i stringToVec3i(String data) {
        Pattern p;
        Matcher m;
        if (data.startsWith("VEC3i_") && (m = (p = Pattern.compile("VEC3i_([-\\d]*)_([-\\d]*)_([-\\d]*)")).matcher(data)).find()) {
            try {
                int x = Integer.parseInt(m.group(1));
                int y = Integer.parseInt(m.group(2));
                int z = Integer.parseInt(m.group(3));
                return new Vec3i(x, y, z);
            }
            catch (NumberFormatException e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to converse the vec");
            }
        }
        return null;
    }

    public static String createCommandData(Player player, PokeStaffComponent.CMDMODE cmdmode) {
        String cmdData = "";
        switch (cmdmode) {
            case MOVE: 
            case ATTACK_POSITION: 
            case MOVE_ATTACK: {
                BlockHitResult result = RayTrace.rayTraceBlock((LivingEntity)player, 16.0);
                BlockPos blockPos = result.getBlockPos();
                cmdData = "VEC3i_%s_%s_%s".formatted(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                break;
            }
            case ATTACK: {
                LivingEntity livingEntity = RayTrace.rayTraceEntity((LivingEntity)player, 16.0);
                if (livingEntity == null) break;
                cmdData = "ENTITY_%s".formatted(livingEntity.getStringUUID());
                break;
            }
            case STAY: {
                cmdData = "POS_SELF";
                break;
            }
            default: {
                cmdData = "";
            }
        }
        return cmdData;
    }

    public static boolean chanceTest(List<Boolean> conditions, List<Float> chances, RandomSource source) {
        if (conditions.size() != chances.size()) {
            CobblemonFightOrFlight.LOGGER.info("The size of the two arrays are not the same");
            return false;
        }
        float chance = source.nextFloat();
        for (int i = 0; i < conditions.size(); ++i) {
            if (!conditions.get(i).booleanValue()) continue;
            return chances.get(i).floatValue() > chance;
        }
        return false;
    }

    public static float toAngle(double num) {
        return (float)(num * 57.2957763671875);
    }

    public static float toRad(double num) {
        return (float)(num / 180.0 * 3.1415927410125732);
    }

    public static void registerMoveData(String moveName, MoveData data) {
        if (MoveData.moveData.containsKey(moveName)) {
            if (MoveData.moveData.get(moveName) != null) {
                MoveData.moveData.get(moveName).add(data);
            }
        } else {
            MoveData.moveData.put(moveName, new ArrayList());
            MoveData.moveData.get(moveName).add(data);
        }
    }

    public static boolean teamCheck(LivingEntity entity1, LivingEntity entity2) {
        TamableAnimal animal2;
        TamableAnimal animal1;
        if (entity1 instanceof TamableAnimal && (animal1 = (TamableAnimal)entity1).getOwner() != null && entity2 instanceof TamableAnimal && (animal2 = (TamableAnimal)entity2).getOwner() != null) {
            LivingEntity owner1 = animal1.getOwner();
            LivingEntity owner2 = animal2.getOwner();
            if (owner1.getTeam() != null || owner2.getTeam() != null) {
                return owner1.getTeam() == owner2.getTeam() || owner1.getTeam() == animal2.getTeam() && owner1.getTeam() != null || animal1.getTeam() == owner2.getTeam() && owner2.getTeam() != null;
            }
        }
        if (entity1.getTeam() != null || entity2.getTeam() != null) {
            return entity1.getTeam() == entity2.getTeam();
        }
        return false;
    }

    public static boolean multiSamplingCollisionCheckBlock(LivingEntity viewer, LivingEntity target, int verticalSampleCount, int horizontalSampleCount, int allowedHit) {
        Level level = viewer.level();
        Vec3 viewerPos = viewer.position();
        Vec3 targetPos = target.position();
        float viewerHeight = viewer.getBbHeight();
        float targetHeight = target.getBbHeight();
        float viewerWidth = viewer.getBbWidth();
        int hit = 0;
        for (int i = 0; i < verticalSampleCount; ++i) {
            for (int j = 0; j < horizontalSampleCount; ++j) {
                for (int k = 0; k < horizontalSampleCount; ++k) {
                    Vec3 v = viewerPos.add((double)(-viewerWidth / 2.0f + viewerWidth * (float)(j + 1) / (float)horizontalSampleCount), (double)(viewerHeight * (float)i / (float)verticalSampleCount), (double)(-viewerWidth / 2.0f + viewerWidth * (float)(k + 1) / (float)horizontalSampleCount));
                    ClipContext context = new ClipContext(v, targetPos.add(0.0, (double)(targetHeight / 2.0f), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)viewer);
                    BlockHitResult result = level.clip(context);
                    if (result.getType().equals((Object)HitResult.Type.MISS)) continue;
                    ++hit;
                }
            }
        }
        return hit <= allowedHit;
    }

    public static boolean multiSamplingCollisionCheckBlock(LivingEntity viewer, LivingEntity target, int verticalSampleCount, int horizontalSampleCount) {
        return FOFUtils.multiSamplingCollisionCheckBlock(viewer, target, verticalSampleCount, horizontalSampleCount, 0);
    }
}

