/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.ExplosivePokemonProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PokemonBullet
extends ExplosivePokemonProjectile {
    public PokemonBullet(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public PokemonBullet(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractPokemonProjectile>)((EntityType)EntityFightOrFlight.BULLET.get()), level);
        this.initPosition(shooter);
    }

    @Override
    public void tick() {
        HitResult hitResult;
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        double e = vec3.x;
        double f = vec3.y;
        double g = vec3.z;
        double h = this.getX() + e;
        double j = this.getY() + f;
        double k = this.getZ() + g;
        double l = vec3.horizontalDistance();
        if (this.noPhysics) {
            this.setYRot((float)(Mth.atan2((double)(-e), (double)(-g)) * 57.2957763671875));
        } else {
            this.setYRot((float)(Mth.atan2((double)e, (double)g) * 57.2957763671875));
        }
        this.setXRot((float)(Mth.atan2((double)f, (double)l) * 57.2957763671875));
        this.setXRot(PokemonBullet.lerpRotation((float)this.xRotO, (float)this.getXRot()));
        this.setYRot(PokemonBullet.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        if (this.isInWater()) {
            for (int o = 0; o < 4; ++o) {
                float p = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, h - e * 0.25, j - f * 0.25, k - g * 0.25, e, f, g);
            }
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)).getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        this.setPos(h, j, k);
        this.checkInsideBlocks();
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
    }
}

