/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PokemonWhirlPool
extends AbstractPokemonAreaEffect {
    public PokemonWhirlPool(EntityType<? extends AbstractPokemonAreaEffect> entityType, Level level) {
        super(entityType, level);
    }

    public PokemonWhirlPool(LivingEntity owner) {
        super((EntityType<? extends AbstractPokemonAreaEffect>)((EntityType)EntityFightOrFlight.WHIRLPOOL.get()), owner.level());
        this.setOwner(owner);
    }

    @Override
    protected void visualEffect() {
        if (this.owner instanceof PokemonEntity && this.isWaiting()) {
            PokemonAttackEffect.makeTypeEffectParticle(6, this, this.getElementalType());
        }
    }

    @Override
    protected void activate() {
        PokemonEntity pokemonEntity;
        super.activate();
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)livingEntity).isAlive()) {
            this.dealDamageInTheArea();
        } else {
            this.discard();
        }
    }

    @Override
    protected void applyExtraEffect(LivingEntity target) {
        MobEffectInstance instance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0);
        target.addEffect(instance, (Entity)this.owner);
    }
}

