/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonAttackTask;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class FOFPokemonRangeTask
extends Behavior<LivingEntity> {
    public FOFPokemonRangeTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity pokemon) {
        PokemonEntity pokemonEntity;
        LivingEntity target;
        if (pokemon instanceof PokemonEntity && (target = FOFPokemonAttackTask.getTarget(pokemonEntity = (PokemonEntity)pokemon)) != null && target.isAlive()) {
            return PokemonUtils.shouldShoot(pokemonEntity) && BehaviorUtils.canSee((LivingEntity)pokemonEntity, (LivingEntity)target) && this.isWithinAttackRange((LivingEntity)pokemonEntity, target);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel level, LivingEntity pokemon, long gameTime) {
        if (pokemon instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)pokemon;
            return pokemonEntity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(level, (LivingEntity)pokemonEntity);
        }
        return false;
    }

    protected void stop(ServerLevel level, LivingEntity pokemon, long gameTime) {
    }

    protected void tick(ServerLevel level, LivingEntity pokemon, long gameTime) {
        PokemonEntity pokemonEntity;
        LivingEntity target;
        if (pokemon instanceof PokemonEntity && (target = FOFPokemonAttackTask.getTarget(pokemonEntity = (PokemonEntity)pokemon)) != null) {
            pokemonEntity.setTarget(target);
            boolean canSee = pokemonEntity.getSensing().hasLineOfSight((Entity)target);
            int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
            if (FOFPokemonAttackTask.sharedStartCondition(pokemonEntity)) {
                if (attackTime == 7 && ((PokemonInterface)pokemonEntity).usingSound()) {
                    PokemonUtils.createSonicBoomParticle(pokemonEntity, target);
                }
                if ((attackTime + 1) % 5 == 0 && ((PokemonInterface)pokemonEntity).usingMagic()) {
                    PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, (Entity)target);
                }
                if (attackTime == 0) {
                    if (!canSee) {
                        return;
                    }
                    this.performRangedAttack(pokemonEntity, target);
                } else if (attackTime < 0) {
                    FOFPokemonAttackTask.refreshAttackTime(pokemonEntity, 10);
                }
            }
        }
    }

    protected boolean isWithinAttackRange(LivingEntity pokemon, LivingEntity target) {
        if (pokemon instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)pokemon;
            double d = pokemonEntity.distanceTo((Entity)target);
            return d < (double)PokemonUtils.getAttackRadius();
        }
        return false;
    }

    protected void performRangedAttack(PokemonEntity pokemonEntity, LivingEntity target) {
        double d = pokemonEntity.distanceToSqr(target.getX(), target.getY(), target.getZ());
        PokemonAttackEffect.pokemonPerformRangedAttack(pokemonEntity, target);
        FOFPokemonAttackTask.resetAttackTime(pokemonEntity, d);
        pokemonEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)FOFPokemonAttackTask.getAttackTime(pokemonEntity));
    }
}

