/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Map;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonAttackTask;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;

public class FOFMoveToAttackTargetTask {
    public static OneShot<LivingEntity> create(Expression speedMultiplierExp, Expression closeEnoughDistanceExp) {
        return BehaviorBuilder.create(context -> context.group((App)context.present(MemoryModuleType.ATTACK_TARGET), (App)context.registered(MemoryModuleType.WALK_TARGET)).apply((Applicative)context, (attackTargetAccessor, walkTargetAccessor) -> (serverLevel, livingEntity, l) -> {
            PokemonEntity pokemonEntity;
            if (livingEntity instanceof PokemonEntity && (PokemonUtils.shouldMelee(pokemonEntity = (PokemonEntity)livingEntity) || PokemonUtils.shouldShoot(pokemonEntity)) && FOFPokemonAttackTask.sharedStartCondition(pokemonEntity)) {
                float extraSpeedMultiplier = PokemonUtils.calculateExtraSpeed(pokemonEntity);
                float speedMultiplier = extraSpeedMultiplier * MoLangExtensionsKt.resolveFloat((MoLangRuntime)MoLangExtensionsKt.getMainThreadRuntime(), (Expression)speedMultiplierExp, (Map)MoLangExtensionsKt.getContextOrEmpty((MoLangRuntime)MoLangExtensionsKt.getMainThreadRuntime()));
                int closeEnoughDistance = PokemonUtils.shouldShoot(pokemonEntity) ? (int)((double)PokemonUtils.getAttackRadius() * 0.6) : MoLangExtensionsKt.resolveInt((MoLangRuntime)MoLangExtensionsKt.getMainThreadRuntime(), (Expression)closeEnoughDistanceExp, (Map)MoLangExtensionsKt.getContextOrEmpty((MoLangRuntime)MoLangExtensionsKt.getMainThreadRuntime()));
                LivingEntity attackTarget = (LivingEntity)context.get(attackTargetAccessor);
                Vec3 position = attackTarget.position();
                WalkTarget walkTarget = context.tryGet(walkTargetAccessor).orElse(null);
                if (walkTarget == null || walkTarget.getTarget().currentPosition().distanceToSqr(position) > (double)closeEnoughDistance) {
                    livingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)attackTarget, speedMultiplier, closeEnoughDistance));
                    return true;
                }
            }
            return false;
        }));
    }
}

