/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class FOFBackUpIfTooClose {
    public static OneShot<LivingEntity> create(int tooCloseDistance, float strafeSpeed) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.WALK_TARGET), (App)instance.registered(MemoryModuleType.LOOK_TARGET), (App)instance.present(MemoryModuleType.ATTACK_TARGET), (App)instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (walkTargetAccessor, lookTargetAccessor, attackTargetAccessor, nearestVisibleLivingEntitiesAccessor) -> (serverLevel, pokemon, l) -> {
            PokemonEntity pokemonEntity;
            LivingEntity livingEntity = (LivingEntity)instance.get(attackTargetAccessor);
            if (pokemon instanceof PokemonEntity && livingEntity.closerThan((Entity)(pokemonEntity = (PokemonEntity)pokemon), (double)tooCloseDistance) && ((NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntitiesAccessor)).contains(livingEntity)) {
                float extraSpeedMultiplier = PokemonUtils.calculateExtraSpeed(pokemonEntity);
                lookTargetAccessor.set((Object)new EntityTracker((Entity)livingEntity, true));
                pokemonEntity.getMoveControl().strafe(-strafeSpeed * extraSpeedMultiplier, 0.0f);
                pokemon.setYRot(Mth.rotateIfNecessary((float)pokemonEntity.getYRot(), (float)pokemonEntity.yHeadRot, (float)0.0f));
                return true;
            }
            return false;
        }));
    }
}

