/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.sensors;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class PokeStaffWalkTargetSensor
extends Sensor<PokemonEntity> {
    protected void doTick(ServerLevel level, PokemonEntity entity) {
        BlockPos blockPos;
        if (!CobblemonFightOrFlight.commonConfig().can_use_poke_staff) {
            return;
        }
        LivingEntity owner = entity.getOwner();
        if (owner instanceof Player && !entity.isBusy() && (blockPos = ((PokemonInterface)entity).getTargetBlockPos()) != BlockPos.ZERO) {
            float speedMultiplier = 0.75f * PokemonUtils.calculateExtraSpeed(entity);
            int closeEnoughDist = 2;
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(blockPos, speedMultiplier, closeEnoughDist));
            if (entity.distanceToSqr(blockPos.getCenter()) < (double)closeEnoughDist) {
                PokemonUtils.finishMoving(entity);
            }
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.WALK_TARGET);
    }
}

