/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import me.rufia.fightorflight.entity.areaeffect.PokemonTornado;
import me.rufia.fightorflight.entity.areaeffect.PokemonWhirlPool;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import me.rufia.fightorflight.entity.projectile.PokemonBullet;
import me.rufia.fightorflight.entity.projectile.PokemonFloatingSpike;
import me.rufia.fightorflight.entity.projectile.PokemonSpike;
import me.rufia.fightorflight.entity.projectile.PokemonStickyWeb;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.projectile.Projectile;

public interface EntityFightOrFlight {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"fightorflight", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<PokemonTracingBullet>> TRACING_BULLET = EntityFightOrFlight.registerProjectile("tracing_bullet", EntityType.Builder.of(PokemonTracingBullet::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f));
    public static final RegistrySupplier<EntityType<PokemonArrow>> ARROW_PROJECTILE = EntityFightOrFlight.registerProjectile("arrow_projectile", EntityType.Builder.of(PokemonArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20));
    public static final RegistrySupplier<EntityType<PokemonBullet>> BULLET = EntityFightOrFlight.registerProjectile("bullet_projectile", EntityType.Builder.of(PokemonBullet::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f));
    public static final RegistrySupplier<EntityType<PokemonSpike>> SPIKE = EntityFightOrFlight.registerProjectile("spike_projectile", EntityType.Builder.of(PokemonSpike::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f));
    public static final RegistrySupplier<EntityType<PokemonFloatingSpike>> FLOATING_SPIKE = EntityFightOrFlight.registerProjectile("floating_spike_projectile", EntityType.Builder.of(PokemonFloatingSpike::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f));
    public static final RegistrySupplier<EntityType<PokemonStickyWeb>> STICKY_WEB = EntityFightOrFlight.registerProjectile("sticky_web", EntityType.Builder.of(PokemonStickyWeb::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f));
    public static final RegistrySupplier<EntityType<PokemonTornado>> TORNADO = EntityFightOrFlight.registerMiscEntity("tornado", EntityType.Builder.of(PokemonTornado::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f));
    public static final RegistrySupplier<EntityType<PokemonWhirlPool>> WHIRLPOOL = EntityFightOrFlight.registerMiscEntity("whirlpool", EntityType.Builder.of(PokemonWhirlPool::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f));
    public static final RegistrySupplier<EntityType<PokemonAreaEffectMagic>> MAGIC_EFFECT = EntityFightOrFlight.registerMiscEntity("magic_effect", EntityType.Builder.of(PokemonAreaEffectMagic::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f));

    public static void bootstrap() {
        ENTITY_TYPES.register();
    }

    public static <T extends LivingEntity> RegistrySupplier<EntityType<T>> register(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)name);
        return ENTITY_TYPES.register(id, () -> {
            EntityType result = builder.build(id.toString());
            EntityAttributeRegistry.register(() -> result, (Supplier)attributes);
            return result;
        });
    }

    public static <T extends Projectile> RegistrySupplier<EntityType<T>> registerProjectile(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)name);
        return ENTITY_TYPES.register(id, () -> builder.build(id.toString()));
    }

    public static <T extends Entity> RegistrySupplier<EntityType<T>> registerMiscEntity(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)name);
        return ENTITY_TYPES.register(id, () -> builder.build(id.toString()));
    }
}

