/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.client.model.PokemonAreaEffectTornadoModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class PokemonAreaEffectTornadoRenderer
extends EntityRenderer<AbstractPokemonAreaEffect> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/tornado.png");
    private final PokemonAreaEffectTornadoModel<AbstractPokemonAreaEffect> model;

    public PokemonAreaEffectTornadoRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonAreaEffectTornadoModel(context.bakeLayer(PokemonAreaEffectTornadoModel.LAYER_LOCATION));
    }

    public void render(AbstractPokemonAreaEffect entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        poseStack.pushPose();
        float tick = (float)entity.tickCount + partialTicks;
        float d = entity.getRadius() * 2.0f;
        float rotSpeed = isWaiting ? 0.2f : (entity.isActivated() ? 0.1f : 0.3f);
        poseStack.scale(d, d, d);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.cos((float)(tick * rotSpeed)) * 180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -1.55, 0.0);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        Color color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.4f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        if (isWaiting) {
            this.model.renderPreEffect(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        } else {
            this.model.renderTornado(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(AbstractPokemonAreaEffect entity) {
        return TEXTURE_LOCATION;
    }
}

