/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.hud.moveslots;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MoveSlotsRender {
    private static final ResourceLocation TYPE_ICON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/types.png");
    private static final int TYPE_ICON_SIZE = 36;
    private static final int DRAW_SIZE = (int)(36.0f * CobblemonFightOrFlight.visualEffectConfig().move_indicator_size);
    private static final float TEXT_SIZE = 0.5f;

    public static void render(GuiGraphics graphics, float tickDelta, Pokemon pokemon) {
        Move move;
        PokemonEntity entity;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (!CobblemonFightOrFlight.visualEffectConfig().enable_move_indicator) {
            return;
        }
        if (player == null || pokemon == null) {
            CobblemonFightOrFlight.LOGGER.info("Failed to render the icon.");
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        PokemonState state = pokemon.getState();
        if (state instanceof SentOutState && (entity = pokemon.getEntity()) != null && (move = PokemonUtils.getMove(entity)) != null) {
            int originX = (int)((float)screenWidth * CobblemonFightOrFlight.visualEffectConfig().move_indicator_x_relative);
            int originY = (int)((float)screenHeight * CobblemonFightOrFlight.visualEffectConfig().move_indicator_y_relative);
            Font font = minecraft.font;
            MoveSlotsRender.renderMoveSlot(graphics, font, originX, originY, entity, move);
        }
    }

    public static void renderMoveSlot(GuiGraphics graphics, Font font, int x, int y, PokemonEntity entity, Move move) {
        ElementalType type = move.getType();
        int cooldown = ((PokemonInterface)entity).getAttackTime();
        int maxCooldown = ((PokemonInterface)entity).getMaxAttackTime();
        float cooldownPer = (float)cooldown / (float)maxCooldown;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (cooldown > 2) {
            graphics.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        }
        graphics.blit(TYPE_ICON_LOCATION, x, y, DRAW_SIZE, DRAW_SIZE, (float)(36 * type.getTextureXMultiplier()), 0.0f, 36, 36, 648, 36);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (cooldown > 1 && maxCooldown != 0) {
            graphics.setColor(0.65f, 0.8f, 1.0f, 0.95f);
            int cdHeight = (int)((float)DRAW_SIZE * (1.0f - cooldownPer));
            graphics.blit(TYPE_ICON_LOCATION, x, y + DRAW_SIZE - cdHeight, DRAW_SIZE, cdHeight, (float)(36 * type.getTextureXMultiplier()), 36.0f - (float)(cdHeight * 36) / (float)DRAW_SIZE, 36, (int)((float)(cdHeight * 36) / (float)DRAW_SIZE), 648, 36);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 1.0f);
        graphics.drawCenteredString(font, (Component)move.getDisplayName(), (int)((float)x / 0.5f), (int)((float)y / 0.5f), 0xFFFFFF);
        poseStack.popPose();
    }
}

