/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class PlayerInvContainer
extends AbstractContainerMenu {
    IItemHandler playerInventory;
    IItemHandler otherPlayerInventory;
    String otherPlayerName;
    Level world;
    Player player;
    Player otherPlayer;
    public Map<String, Integer> slotAmounts;

    public PlayerInvContainer(final Player player, Player otherPlayer, int id, String otherPlayerName, Map<String, Integer> slotAmounts, int curioSlotcount) {
        super(null, id);
        this.otherPlayerName = otherPlayerName;
        this.world = player.getCommandSenderWorld();
        this.player = player;
        this.playerInventory = new InvWrapper((Container)player.getInventory());
        if (otherPlayer == null) {
            SimpleContainer i = new SimpleContainer(this, 41){

                public boolean canPlaceItem(int index, ItemStack stack) {
                    if (index == 36) {
                        return stack.canEquip(EquipmentSlot.FEET, (LivingEntity)player);
                    }
                    if (index == 37) {
                        return stack.canEquip(EquipmentSlot.LEGS, (LivingEntity)player);
                    }
                    if (index == 38) {
                        return stack.canEquip(EquipmentSlot.CHEST, (LivingEntity)player);
                    }
                    if (index == 39) {
                        return stack.canEquip(EquipmentSlot.HEAD, (LivingEntity)player);
                    }
                    return true;
                }
            };
            this.otherPlayerInventory = new InvWrapper((Container)i);
        } else {
            this.otherPlayer = otherPlayer;
            this.otherPlayerInventory = new InvWrapper((Container)otherPlayer.getInventory());
        }
        this.layoutPlayerInventorySlots(this.playerInventory, 25, 105);
        this.layoutPlayerInventorySlots(this.otherPlayerInventory, 25, -13);
        this.layoutArmorAndOffhandSlots(this.playerInventory, -10, 97);
        this.layoutArmorAndOffhandSlots(this.otherPlayerInventory, -10, -21);
    }

    private void layoutArmorAndOffhandSlots(IItemHandler playerInventory, int x, int y) {
        y += 54;
        for (int i = 0; i < 4; ++i) {
            final int finalI = 36 + i;
            this.addSlot((Slot)new SlotItemHandler(playerInventory, finalI, x, y){

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    if (finalI == 36) {
                        return stack.canEquip(EquipmentSlot.FEET, (LivingEntity)PlayerInvContainer.this.player);
                    }
                    if (finalI == 37) {
                        return stack.canEquip(EquipmentSlot.LEGS, (LivingEntity)PlayerInvContainer.this.player);
                    }
                    if (finalI == 38) {
                        return stack.canEquip(EquipmentSlot.CHEST, (LivingEntity)PlayerInvContainer.this.player);
                    }
                    if (finalI == 39) {
                        return stack.canEquip(EquipmentSlot.HEAD, (LivingEntity)PlayerInvContainer.this.player);
                    }
                    return true;
                }
            });
            y -= 18;
        }
        this.addSlot((Slot)new SlotItemHandler(playerInventory, 40, x, y + 90 + 4));
    }

    private void layoutCurioSlots(Player player, int x, int y, Collection<Integer> curioSlots, IItemHandler curiosInv) {
        if (player != null) {
            ICuriosItemHandler cinventory = CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
            if (cinventory == null) {
                return;
            }
            int temp = x;
            int g = 0;
            for (Map.Entry entry : cinventory.getCurios().entrySet()) {
                if (g == 4) {
                    y -= 120;
                }
                x = g < 4 ? temp : -26 - 18 * ((ICurioStacksHandler)entry.getValue()).getSlots();
                this.addSlotRange((IItemHandler)((ICurioStacksHandler)entry.getValue()).getStacks(), 0, x, y, ((ICurioStacksHandler)entry.getValue()).getSlots(), 18);
                y += 30;
                ++g;
            }
        } else {
            int temp = x;
            int g = 0;
            int index = 0;
            for (Integer j : curioSlots) {
                if (g == 4) {
                    y -= 120;
                }
                x = g < 4 ? temp : -26 - 18 * j;
                this.addSlotRange(curiosInv, index, x, y, j, 18);
                index += j.intValue();
                y += 30;
                ++g;
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(IItemHandler playerInventory, int leftCol, int topRow) {
        this.addSlotBox(playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!this.world.isClientSide() && !playerIn.getServer().getPlayerList().getPlayers().contains(this.otherPlayer)) {
            CuriosApi.getCuriosInventory((LivingEntity)this.otherPlayer);
            ((ServerLevel)this.world).getServer().playerDataStorage.save(this.otherPlayer);
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }
}

