/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record TeleportMessage(ResourceKey<Level> origin, ResourceKey<Level> dest, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("teleportmessage"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, TeleportMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), TeleportMessage::origin, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), TeleportMessage::dest, (StreamCodec)BlockPos.STREAM_CODEC, TeleportMessage::pos, TeleportMessage::new);

    public static void handle(TeleportMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (!player.hasPermissions(2)) {
            return;
        }
        ServerLevel ori = player.getServer().getLevel(data.origin);
        ServerLevel dest = player.getServer().getLevel(data.dest);
        WorldUtils.teleportPlayer((Player)player, (Level)ori, (Level)dest, data.pos);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

