/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemoveEntitiesMessage(ResourceKey<Level> worldRegistryKey, ResourceLocation rl, ChunkPos pos, boolean tile, boolean force, boolean All) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveEntitiesMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("removeentitiesmessage"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, RemoveEntitiesMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), RemoveEntitiesMessage::worldRegistryKey, (StreamCodec)ResourceLocation.STREAM_CODEC, RemoveEntitiesMessage::rl, (StreamCodec)ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong), RemoveEntitiesMessage::pos, (StreamCodec)ByteBufCodecs.BOOL, RemoveEntitiesMessage::tile, (StreamCodec)ByteBufCodecs.BOOL, RemoveEntitiesMessage::force, (StreamCodec)ByteBufCodecs.BOOL, RemoveEntitiesMessage::All, RemoveEntitiesMessage::new);

    public static boolean handle(RemoveEntitiesMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (!player.hasPermissions(2)) {
            return true;
        }
        ServerLevel world = player.getServer().getLevel(data.worldRegistryKey);
        if (data.All) {
            if (data.tile) {
                WorldUtils.removeTileEntityType((Level)world, data.rl, data.force);
            } else {
                WorldUtils.removeEntityType((Level)world, data.rl, data.force);
            }
        } else if (data.tile) {
            WorldUtils.removeTileEntitiesInChunk((Level)world, data.pos, data.rl, data.force);
        } else {
            WorldUtils.removeEntitiesInChunk((Level)world, data.pos, data.rl, data.force);
        }
        return true;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

