/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.DataStructures.WorldPos;
import com.darkere.crashutils.Screens.CUOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public abstract class LocationData {
    Map<ChunkPos, List<WorldPos>> chunkMap = new HashMap<ChunkPos, List<WorldPos>>();
    Map<ChunkPos, WorldPos> tpPos = new HashMap<ChunkPos, WorldPos>();
    Map<ResourceLocation, List<WorldPos>> map = new HashMap<ResourceLocation, List<WorldPos>>();
    int total = 0;
    String lastFill = "";

    public LocationData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public LocationData() {
    }

    public Map<ResourceLocation, List<WorldPos>> getMap() {
        return this.map;
    }

    public HashMap<ResourceLocation, List<WorldPos>> getHashMap() {
        return (HashMap)this.map;
    }

    public void fillChunkMaps(String rl) {
        if (this.lastFill.equals(rl)) {
            return;
        }
        this.lastFill = rl;
        ResourceLocation resourceLocation = ResourceLocation.parse((String)rl);
        this.chunkMap.clear();
        this.tpPos.clear();
        ArrayList positions = new ArrayList();
        if (rl.isEmpty()) {
            this.map.values().forEach(positions::addAll);
        } else {
            positions.addAll(this.map.get(resourceLocation));
        }
        for (WorldPos pos : positions) {
            ChunkPos chunkPos = new ChunkPos(pos.pos());
            if (!this.chunkMap.containsKey(chunkPos)) {
                this.chunkMap.put(chunkPos, new ArrayList());
            }
            this.chunkMap.get(chunkPos).add(pos);
            this.tpPos.put(chunkPos, pos);
        }
    }

    public int getCountForChunk(ChunkPos chunkPos, String filter) {
        if (this.chunkMap == null) {
            return 0;
        }
        this.fillChunkMaps(filter);
        if (this.chunkMap.get(chunkPos) == null) {
            return 0;
        }
        return this.chunkMap.get(chunkPos).size();
    }

    public List<CUOption> getAsCUOptions() {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        this.map.forEach((type, chunks) -> {
            if (!chunks.isEmpty()) {
                list.add(new CUOption((ResourceLocation)type, chunks.size()));
            }
        });
        return list;
    }

    public List<CUOption> getAsCUOptionsOfType(ResourceLocation name) {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        this.fillChunkMaps(name.toString());
        this.chunkMap.forEach((chunk, listPos) -> {
            if (!listPos.isEmpty()) {
                list.add(new CUOption((ChunkPos)chunk, listPos.size(), name));
            }
        });
        return list;
    }

    public List<CUOption> getInChunkAsCUOptions(ChunkPos chunkPos, ResourceLocation name) {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        this.fillChunkMaps(name.toString());
        List<WorldPos> chunks = this.chunkMap.get(chunkPos);
        if (chunks == null) {
            return List.of();
        }
        chunks.forEach(pos -> list.add(new CUOption(pos.pos(), pos.id())));
        return list;
    }

    public void resetChunkMap() {
        this.lastFill = "THISWILLRELOADTHECHUNKMAP";
    }
}

