/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.gui;

import com.leobeliik.convenientcurioscontainer.ConvenientCuriosContainerCommon;
import com.leobeliik.convenientcurioscontainer.common.ConvenientMenu;
import com.leobeliik.convenientcurioscontainer.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class ConvenientScreen
extends AbstractContainerScreen<ConvenientMenu> {
    private static ResourceLocation CONTAINER_BACKGROUND;
    private final int xSize = 176;
    private final int ySize = 222;
    private Button btnNext;
    private Button btnPrev;

    public ConvenientScreen(ConvenientMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = 129;
    }

    protected void init() {
        String darkMode = Services.PLATFORM.darkMode() ? "textures/gui/convenient_screen_dark.png" : "textures/gui/convenient_screen.png";
        CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"convenientcurioscontainer", (String)darkMode);
        this.addButtons();
        super.init();
    }

    protected void renderLabels(GuiGraphics ms, int x, int y) {
        ms.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x161616, false);
        ms.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x161616, false);
    }

    public void render(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderWidgets(ms, mouseX, mouseY, partialTicks);
        this.renderTooltip(ms, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        ms.blit(CONTAINER_BACKGROUND, this.getX(), this.getY(), 0, 0, 176, 222);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode) || ConvenientCuriosContainerCommon.OPEN_CONVENIENT_SCREEN_KEY.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderTooltip(@NotNull GuiGraphics gg, int mouseX, int mouseY) {
        int maxPage;
        if (mouseX > this.getX() + 162 && mouseX < this.getX() + 172 && mouseY > this.getY() + 4 && mouseY < this.getY() + 14) {
            gg.renderTooltip(this.font, List.of(Component.translatable((String)"gui.container_info").withStyle(ChatFormatting.AQUA), Component.translatable((String)"gui.container_RMB").withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.container_SRMB").withStyle(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY + 5);
        }
        if ((maxPage = ((ConvenientMenu)this.getMenu()).getMaxPage()) > 1 && mouseX >= this.btnPrev.getX() && mouseX <= this.btnPrev.getX() + 23 && mouseY >= this.btnNext.getY() && mouseY <= this.btnNext.getY() + 12) {
            gg.renderTooltip(this.font, (Component)Component.translatable((String)"gui.curios.page", (Object[])new Object[]{((ConvenientMenu)this.getMenu()).getCurrentPage(), maxPage}), mouseX, mouseY);
        }
        for (Slot slot : ((ConvenientMenu)this.menu).slots.subList(90, ((ConvenientMenu)this.menu).slots.size())) {
            boolean mouseInSlot;
            boolean bl = mouseInSlot = mouseX >= this.leftPos + slot.x && mouseX <= this.leftPos + slot.x + 16 && mouseY >= this.topPos + slot.y && mouseY <= this.topPos + slot.y + 16;
            if (!slot.getItem().isEmpty() || !mouseInSlot) continue;
            gg.renderTooltip(this.font, (Component)Component.translatable((String)slot.toString()), mouseX, mouseY);
        }
        super.renderTooltip(gg, mouseX, mouseY);
    }

    private void addButtons() {
        this.btnNext = Button.builder((Component)Component.empty(), b -> ((ConvenientMenu)this.getMenu()).ChangePage(true)).pos(this.getX() - 13, this.getY()).size(12, 12).build();
        this.addWidget((GuiEventListener)this.btnNext);
        this.btnPrev = Button.builder((Component)Component.empty(), b -> ((ConvenientMenu)this.getMenu()).ChangePage(false)).pos(this.getX() - 25, this.getY()).size(12, 12).build();
        this.addWidget((GuiEventListener)this.btnPrev);
    }

    private void renderWidgets(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        int size = ((ConvenientMenu)this.menu).slots.size();
        int curiosSize = ((ConvenientMenu)this.menu).curiosSize;
        int currentPage = ((ConvenientMenu)this.menu).getCurrentPage();
        gg.blit(CONTAINER_BACKGROUND, this.btnNext.getX(), this.btnNext.getY(), 188.0f, 0.0f, this.btnNext.getWidth(), this.btnNext.getHeight(), 256, 256);
        gg.blit(CONTAINER_BACKGROUND, this.btnPrev.getX(), this.btnPrev.getY(), 176.0f, 0.0f, this.btnPrev.getWidth(), this.btnPrev.getHeight(), 256, 256);
        boolean bl = this.btnNext.active = ((ConvenientMenu)this.menu).getMaxPage() != currentPage;
        if (this.btnNext.isActive() && this.btnNext.isMouseOver((double)mouseX, (double)mouseY)) {
            gg.blit(CONTAINER_BACKGROUND, this.btnNext.getX(), this.btnNext.getY(), 200.0f, 0.0f, this.btnNext.getWidth(), this.btnNext.getHeight(), 256, 256);
        }
        boolean bl2 = this.btnPrev.active = currentPage > 1;
        if (this.btnPrev.isActive() && this.btnPrev.isMouseOver((double)mouseX, (double)mouseY)) {
            gg.blit(CONTAINER_BACKGROUND, this.btnPrev.getX(), this.btnPrev.getY(), 200.0f, 0.0f, this.btnPrev.getWidth(), this.btnPrev.getHeight(), 256, 256);
        }
        for (int i = 0; i < Math.min(Math.ceilDiv(curiosSize - 33 * (currentPage - 1), 11), 3); ++i) {
            gg.blit(CONTAINER_BACKGROUND, this.leftPos - 26 - 18 * i, this.topPos + 12, 176, 12, i == 0 ? 26 : 23, 210);
        }
        for (Slot slot : ((ConvenientMenu)this.menu).slots.subList(90, Math.min(123, size))) {
            gg.blit(CONTAINER_BACKGROUND, this.leftPos + slot.x - 1, this.topPos + slot.y, 7, 17, 18, 18);
        }
    }

    private int getX() {
        return (this.width - 176) / 2;
    }

    private int getY() {
        return (this.height - 222) / 2;
    }

    public void onClose() {
        super.onClose();
    }
}

