/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer;

import com.google.common.collect.ImmutableSet;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public abstract class Compat {
    public static List<Slot> getCurioSlots(Player player) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        ICuriosItemHandler curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
        int tall = 0;
        int wide = 0;
        if (curiosHandler != null) {
            Map curioMap = curiosHandler.getCurios();
            for (final String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                int i = 0;
                while (i < stackHandler.getSlots()) {
                    if (tall != 0 && tall % 11 == 0) {
                        tall = 0;
                        if (--wide == -3) {
                            wide = 0;
                        }
                    }
                    slots.add((Slot)new CurioSlot(player, stackHandler, i, identifier, wide * 18 - 20, tall * 18 + 18, stacksHandler.getActiveStates(), (List)stacksHandler.getRenders(), stacksHandler.canToggleRendering(), false, false){

                        public String toString() {
                            return "curios.identifier." + identifier;
                        }
                    });
                    ++i;
                    ++tall;
                }
            }
        }
        return slots;
    }

    public static List<Slot> getAccessoriesSlots(Player player) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        ImmutableSet usedSlots = ImmutableSet.copyOf((Collection)AccessoriesAPI.getUsedSlotsFor((Player)player));
        List slotTypes = SlotGroupLoader.getGroups((Level)player.level(), (boolean)true).stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).flatMap(slotGroup -> {
            if (slotGroup.name().equals("accessories")) {
                return Stream.of(new SlotType[0]);
            }
            return slotGroup.slots().stream().map(s -> {
                SlotType slotType = SlotTypeLoader.getSlotType((Level)player.level(), (String)s);
                return !usedSlots.contains((Object)slotType) ? null : slotType;
            }).filter(Objects::nonNull).sorted(Comparator.comparingInt(SlotType::order).reversed());
        }).toList();
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability != null) {
            int tall = 0;
            int wide = 0;
            for (SlotType slot : slotTypes) {
                AccessoriesContainer accessoryContainer = (AccessoriesContainer)capability.getContainers().get(slot.name());
                if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
                int i = 0;
                while (i < accessoryContainer.getSize()) {
                    if (tall != 0 && tall % 11 == 0) {
                        --wide;
                        tall = 0;
                    }
                    slots.add((Slot)new AccessoriesInternalSlot(accessoryContainer, false, i, wide * 18 - 20, tall * 18 + 18){

                        public String toString() {
                            return this.slotType().translation();
                        }
                    });
                    ++i;
                    ++tall;
                }
            }
        }
        return slots;
    }
}

