/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.inventory;

import fuzs.limitlesscontainers.api.limitlesscontainers.v1.LimitlessContainerMenu;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedContainer;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedSimpleContainer;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedSlot;
import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NetherChestMenu
extends LimitlessContainerMenu {
    private final int containerRows = 6;
    private final MultipliedContainer container;

    public NetherChestMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (MultipliedContainer)new MultipliedSimpleContainer(((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).stackSizeMultiplier, 54));
    }

    public NetherChestMenu(int containerId, Inventory inventory, MultipliedContainer container) {
        super((MenuType)ModRegistry.NETHER_CHEST_MENU_TYPE.value(), containerId);
        NetherChestMenu.checkContainerSize((Container)container, (int)(this.containerRows * 9));
        this.container = container;
        container.startOpen(inventory.player);
        this.addContainerSlots();
        ContainerMenuHelper.addInventorySlots((AbstractContainerMenu)this, (Inventory)inventory, (int)(109 + (this.containerRows - 4) * 18));
    }

    private void addContainerSlots() {
        for (int l = 0; l < this.containerRows; ++l) {
            for (int m = 0; m < 9; ++m) {
                this.addSlot((Slot)new MultipliedSlot(this.container, m + l * 9, 8 + m * 18, 19 + l * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < this.containerRows * 9 ? !this.moveItemStackTo(itemStack2, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public boolean is(Container container) {
        return this.container == container;
    }
}

