/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world.placement;

import artifacts.Artifacts;
import artifacts.config.value.Value;
import artifacts.registry.ModPlacementModifierTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ConfigValueFilter
extends PlacementFilter {
    public static final MapCodec<ConfigValueFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Artifacts.CONFIG.general.campsite.codec().fieldOf("value").forGetter(f -> f.value), (App)Codec.BOOL.fieldOf("expected").forGetter(f -> f.expected)).apply((Applicative)instance, ConfigValueFilter::new));
    private final Value.ConfigValue<Boolean> value;
    private final boolean expected;

    private ConfigValueFilter(Value.ConfigValue<Boolean> value, boolean expected) {
        this.value = value;
        this.expected = expected;
    }

    public static ConfigValueFilter checkValue(Value.ConfigValue<Boolean> value, boolean expected) {
        return new ConfigValueFilter(value, expected);
    }

    protected boolean shouldPlace(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        return this.value.get() ^ !this.expected;
    }

    public PlacementModifierType<?> type() {
        return ModPlacementModifierTypes.CONFIG_VALUE_FILTER.value();
    }
}

