/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;

public record CampsiteChestConfiguration(Optional<Double> mimicChance, double trappedChestChance, Optional<ResourceKey<LootTable>> chestLootTable) {
    public static final Codec<CampsiteChestConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("mimic_chance").forGetter(CampsiteChestConfiguration::mimicChance), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("trapped_chest_chance", (Object)0.0).forGetter(CampsiteChestConfiguration::trappedChestChance), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).optionalFieldOf("chest_loot_table").forGetter(CampsiteChestConfiguration::chestLootTable)).apply((Applicative)instance, CampsiteChestConfiguration::new));

    public double getMimicChance() {
        return this.mimicChance().orElse(Artifacts.CONFIG.general.campsite.mimicChance.get());
    }
}

