/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModTags;
import artifacts.world.CampsiteChestConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public abstract class AbstractCampsiteFeature<FC extends FeatureConfiguration>
extends Feature<FC> {
    public AbstractCampsiteFeature(Codec<FC> codec) {
        super(codec);
    }

    public void placeChest(WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing, CampsiteChestConfiguration config) {
        if ((double)random.nextFloat() < config.getMimicChance()) {
            MimicEntity mimic = (MimicEntity)ModEntityTypes.MIMIC.get().create((Level)level.getLevel());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)mimic);
            }
        } else {
            BlockState chest;
            if ((double)random.nextFloat() < config.trappedChestChance()) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.TNT.defaultBlockState());
                chest = Blocks.TRAPPED_CHEST.defaultBlockState();
                this.setBlock((LevelWriter)level, pos, (BlockState)Blocks.TRAPPED_CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random)));
            } else {
                chest = Artifacts.CONFIG.general.campsite.useModdedChests.get() != false ? ModTags.getTag(ModTags.CAMPSITE_CHESTS).getRandomElement(random).map(Holder::value).orElse(Blocks.CHEST).defaultBlockState() : Blocks.CHEST.defaultBlockState();
            }
            if (chest.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                chest = (BlockState)chest.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            }
            this.setBlock((LevelWriter)level, pos, chest);
            config.chestLootTable().ifPresent(lootTable -> RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)pos, (ResourceKey)lootTable));
        }
    }
}

