/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.Artifacts;
import artifacts.component.HurtSound;
import artifacts.component.ToggleIdentifier;
import artifacts.component.ability.CureEffects;
import artifacts.component.ability.DamageAbsorption;
import artifacts.component.ability.DamageImmunity;
import artifacts.component.ability.DeathProtectionTeleport;
import artifacts.component.ability.DoubleJump;
import artifacts.component.ability.EnderPearlHungerCost;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.FluidCollision;
import artifacts.component.ability.PostDamageCooldown;
import artifacts.component.ability.ReplenishHungerOnGrass;
import artifacts.component.ability.SwimInAir;
import artifacts.component.ability.ToolTierUpgrade;
import artifacts.component.ability.mobeffect.AttackEffects;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.component.ability.mobeffect.PostDamageEffects;
import artifacts.component.ability.mobeffect.PostEatingEffects;
import artifacts.component.ability.retaliation.FireEffect;
import artifacts.component.ability.retaliation.LightningEffect;
import artifacts.component.ability.retaliation.RetaliationEffects;
import artifacts.component.ability.retaliation.ThornsEffect;
import artifacts.config.value.Value;
import artifacts.item.EverlastingFoodItem;
import artifacts.item.UmbrellaItem;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModMobEffects;
import artifacts.registry.ModSoundEvents;
import artifacts.registry.ModTags;
import artifacts.registry.Register;
import artifacts.registry.RegistryHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class ModItems {
    public static final Register<Item> ITEMS = Register.create(Registries.ITEM);
    public static final Register<CreativeModeTab> CREATIVE_MODE_TABS = Register.create(Registries.CREATIVE_MODE_TAB);
    public static final RegistryHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("main", () -> new CreativeModeTab.Builder(null, 0).title((Component)Component.translatable((String)"%s.creative_tab".formatted("artifacts"))).icon(() -> new ItemStack((ItemLike)BUNNY_HOPPERS.value())).displayItems((parameters, output) -> ITEMS.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static final Holder<Item> MIMIC_SPAWN_EGG = ModItems.register("mimic_spawn_egg", () -> PlatformServices.platformHelper.createMimicSpawnEgg(new Item.Properties()));
    public static final Holder<Item> UMBRELLA = ModItems.register("umbrella", UmbrellaItem::new);
    public static final Holder<Item> EVERLASTING_BEEF = ModItems.register("everlasting_beef", () -> new EverlastingFoodItem(new FoodProperties.Builder().nutrition(3).saturationModifier(0.3f).build(), Artifacts.CONFIG.items.everlastingBeefCooldown, Artifacts.CONFIG.items.everlastingBeefEnabled));
    public static final Holder<Item> ETERNAL_STEAK = ModItems.register("eternal_steak", () -> new EverlastingFoodItem(new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build(), Artifacts.CONFIG.items.eternalSteakCooldown, Artifacts.CONFIG.items.eternalSteakEnabled));
    public static final Holder<Item> PLASTIC_DRINKING_HAT = ModItems.wearableItem("plastic_drinking_hat", builder -> builder.equipSound(SoundEvents.BOTTLE_FILL).addAttributeModifier(ModAttributes.DRINKING_SPEED, Artifacts.CONFIG.items.plasticDrinkingHatDrinkingSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(ModAttributes.EATING_SPEED, Artifacts.CONFIG.items.plasticDrinkingHatEatingSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> NOVELTY_DRINKING_HAT = ModItems.wearableItem("novelty_drinking_hat", builder -> builder.equipSound(SoundEvents.BOTTLE_FILL).component(ModDataComponents.ABILITY_LORE.get(), new ItemLore(List.of(Component.translatable((String)"artifacts.tooltip.item.novelty_drinking_hat").withStyle(ChatFormatting.GRAY)))).addAttributeModifier(ModAttributes.DRINKING_SPEED, Artifacts.CONFIG.items.noveltyDrinkingHatDrinkingSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(ModAttributes.EATING_SPEED, Artifacts.CONFIG.items.noveltyDrinkingHatEatingSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> SNORKEL = ModItems.wearableItem("snorkel", builder -> builder.mobEffect((Holder<MobEffect>)MobEffects.WATER_BREATHING, Value.of(1), Artifacts.CONFIG.items.snorkelWaterBreathingDuration, Artifacts.CONFIG.items.snorkelIsInfinite.get() != false ? EntityCondition.ALWAYS : EntityCondition.ABOVE_WATER));
    public static final Holder<Item> NIGHT_VISION_GOGGLES = ModItems.wearableItem("night_vision_goggles", builder -> builder.mobEffect((Holder<MobEffect>)MobEffects.NIGHT_VISION, Value.of(1), Value.of(10), EntityCondition.ALWAYS).component(ModDataComponents.REDUCED_NIGHT_VISION.get(), Artifacts.CONFIG.items.nightVisionGogglesStrength).component(ModDataComponents.TOGGLE_KEY.get(), ToggleIdentifier.NIGHT_VISION_GOGGLES));
    public static final Holder<Item> VILLAGER_HAT = ModItems.wearableItem("villager_hat", builder -> builder.addAttributeModifier(ModAttributes.VILLAGER_REPUTATION, Artifacts.CONFIG.items.villagerHatReputationBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> SUPERSTITIOUS_HAT = ModItems.wearableItem("superstitious_hat", builder -> builder.increasesEnchantment((ResourceKey<Enchantment>)Enchantments.LOOTING, Artifacts.CONFIG.items.superstitiousHatLootingLevelBonus));
    public static final Holder<Item> COWBOY_HAT = ModItems.wearableItem("cowboy_hat", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER).addAttributeModifier(ModAttributes.MOUNT_SPEED, Artifacts.CONFIG.items.cowboyHatMountSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> ANGLERS_HAT = ModItems.wearableItem("anglers_hat", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER).increasesEnchantment((ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, Artifacts.CONFIG.items.anglersHatLuckOfTheSeaLevelBonus).increasesEnchantment((ResourceKey<Enchantment>)Enchantments.LURE, Artifacts.CONFIG.items.anglersHatLureLevelBonus));
    public static final Holder<Item> LUCKY_SCARF = ModItems.wearableItem("lucky_scarf", builder -> builder.increasesEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, Artifacts.CONFIG.items.luckScarfFortuneBonus));
    public static final Holder<Item> SCARF_OF_INVISIBILITY = ModItems.wearableItem("scarf_of_invisibility", builder -> builder.mobEffect((Holder<MobEffect>)MobEffects.INVISIBILITY, Value.of(1), Value.of(10), Artifacts.CONFIG.items.scarfOfInvisibilityEnabled.get() != false ? EntityCondition.ALWAYS : EntityCondition.NEVER).component(ModDataComponents.TOGGLE_KEY.get(), ToggleIdentifier.SCARF_OF_INVISIBILITY).component(ModDataComponents.HIDE_WHEN_INVISIBLE.get(), Artifacts.CONFIG.items.scarfOfInvisibilityHideWhenInvisible));
    public static final Holder<Item> CROSS_NECKLACE = ModItems.wearableItem("cross_necklace", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND).component(ModDataComponents.PIGLIN_LOVED.get()).component(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), new PostDamageCooldown(Artifacts.CONFIG.items.crossNecklaceCooldown, Optional.empty())).addAttributeModifier(ModAttributes.INVINCIBILITY_TICKS, Artifacts.CONFIG.items.crossNecklaceBonusInvincibilityTicks, AttributeModifier.Operation.ADD_VALUE, false));
    public static final Holder<Item> PANIC_NECKLACE = ModItems.wearableItem("panic_necklace", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND).component(ModDataComponents.POST_DAMAGE_EFFECTS.get(), new PostDamageEffects(List.of(new PostDamageEffects.Entry(new MobEffectProvider((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, Artifacts.CONFIG.items.panicNecklaceSpeedLevel, Artifacts.CONFIG.items.panicNecklaceSpeedDuration, Value.of(true), Value.of(true), EntityCondition.ALWAYS), Optional.empty(), Value.of(1.0))))).component(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), new PostDamageCooldown(Artifacts.CONFIG.items.panicNecklaceCooldown, Optional.empty())));
    public static final Holder<Item> SHOCK_PENDANT = ModItems.wearableItem("shock_pendant", builder -> builder.component(ModDataComponents.RETALIATION_EFFECTS.get(), new RetaliationEffects(Optional.empty(), Optional.empty(), Optional.of(new LightningEffect(Artifacts.CONFIG.items.shockPendantStrikeChance, Artifacts.CONFIG.items.shockPendantCooldown)))).component(ModDataComponents.DAMAGE_IMMUNITY.get(), new DamageImmunity(Artifacts.CONFIG.items.shockPendantCancelLightningDamage, (TagKey<DamageType>)DamageTypeTags.IS_LIGHTNING, EntityCondition.ALWAYS)));
    public static final Holder<Item> FLAME_PENDANT = ModItems.wearableItem("flame_pendant", builder -> builder.component(ModDataComponents.RETALIATION_EFFECTS.get(), new RetaliationEffects(Optional.empty(), Optional.of(new FireEffect(Artifacts.CONFIG.items.flamePendantStrikeChance, Artifacts.CONFIG.items.flamePendantCooldown, Artifacts.CONFIG.items.flamePendantFireDuration, Artifacts.CONFIG.items.flamePendantGrantFireResistance)), Optional.empty())));
    public static final Holder<Item> THORN_PENDANT = ModItems.wearableItem("thorn_pendant", builder -> builder.component(ModDataComponents.RETALIATION_EFFECTS.get(), new RetaliationEffects(Optional.of(new ThornsEffect(Artifacts.CONFIG.items.thornPendantStrikeChance, Artifacts.CONFIG.items.thornPendantCooldown, Artifacts.CONFIG.items.thornPendantMinDamage, Artifacts.CONFIG.items.thornPendantMaxDamage)), Optional.empty(), Optional.empty())));
    public static final Holder<Item> CHARM_OF_SINKING = ModItems.wearableItem("charm_of_sinking", builder -> builder.component(ModDataComponents.SINKING.get(), Artifacts.CONFIG.items.charmOfSinkingEnabled).component(ModDataComponents.DAMAGE_IMMUNITY.get(), new DamageImmunity(Artifacts.CONFIG.items.charmOfSinkingEnabled, (TagKey<DamageType>)DamageTypeTags.IS_FALL, Artifacts.CONFIG.items.charmOfSinkingUnderwaterFallDamage.get() != false ? EntityCondition.NEVER : EntityCondition.IN_WATER)).addAttributeModifier((Holder<Attribute>)Attributes.OXYGEN_BONUS, Artifacts.CONFIG.items.charmOfSinkingEnabled.get() != false ? Artifacts.CONFIG.items.charmOfSinkingOxygenBonus : Value.of(0.0), AttributeModifier.Operation.ADD_VALUE).component(ModDataComponents.TOGGLE_KEY.get(), ToggleIdentifier.CHARM_OF_SINKING));
    public static final Holder<Item> CHARM_OF_SHRINKING = ModItems.wearableItem("charm_of_shrinking", builder -> builder.addAttributeModifier((Holder<Attribute>)Attributes.SCALE, Artifacts.CONFIG.items.charmOfShrinkingScaleModifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).component(ModDataComponents.TOGGLE_KEY.get(), ToggleIdentifier.CHARM_OF_SHRINKING));
    public static final Holder<Item> CLOUD_IN_A_BOTTLE = ModItems.wearableItem("cloud_in_a_bottle", builder -> builder.equipSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH).component(ModDataComponents.DOUBLE_JUMP.get(), new DoubleJump(Artifacts.CONFIG.items.cloudInABottleEnabled, Artifacts.CONFIG.items.cloudInABottleFallDamageMultiplier, Artifacts.CONFIG.items.cloudInABottleSprintJumpHorizontalVelocity, Artifacts.CONFIG.items.cloudInABottleSprintJumpVerticalVelocity)).addAttributeModifier((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, Artifacts.CONFIG.items.cloudInABottleSafeFallDistanceBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> OBSIDIAN_SKULL = ModItems.wearableItem("obsidian_skull", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON).component(ModDataComponents.POST_DAMAGE_EFFECTS.get(), new PostDamageEffects(List.of(new PostDamageEffects.Entry(new MobEffectProvider((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, Value.of(1), Artifacts.CONFIG.items.obsidianSkullFireResistanceDuration, Value.of(true), Value.of(true), EntityCondition.ALWAYS), Optional.of(DamageTypeTags.IS_FIRE), Value.of(1.0))))).component(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), new PostDamageCooldown(Artifacts.CONFIG.items.obsidianSkullCooldown, Optional.of(DamageTypeTags.IS_FIRE))));
    public static final Holder<Item> ANTIDOTE_VESSEL = ModItems.wearableItem("antidote_vessel", builder -> builder.equipSound(SoundEvents.BOTTLE_FILL).component(ModDataComponents.PIGLIN_LOVED.get()).component(ModDataComponents.CURE_EFFECTS.get(), new CureEffects(Artifacts.CONFIG.items.antidoteVesselEnabled, Artifacts.CONFIG.items.antidoteVesselMaxEffectDuration)));
    public static final Holder<Item> UNIVERSAL_ATTRACTOR = ModItems.wearableItem("universal_attractor", builder -> builder.component(ModDataComponents.PIGLIN_LOVED.get()).mobEffect(ModMobEffects.MAGNETISM, Artifacts.CONFIG.items.universalAttractorMagnetismLevel, Value.of(10), EntityCondition.ALWAYS).component(ModDataComponents.TOGGLE_KEY.get(), ToggleIdentifier.UNIVERSAL_ATTRACTOR));
    public static final Holder<Item> CRYSTAL_HEART = ModItems.wearableItem("crystal_heart", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND).addAttributeModifier((Holder<Attribute>)Attributes.MAX_HEALTH, Artifacts.CONFIG.items.crystalHeartHealthBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> HELIUM_FLAMINGO = ModItems.wearableItem("helium_flamingo", builder -> builder.equipSound(ModSoundEvents.POP).component(ModDataComponents.SWIM_IN_AIR.get(), new SwimInAir(Artifacts.CONFIG.items.heliumFlamingoFlightDuration, Artifacts.CONFIG.items.heliumFlamingoRechargeDuration, Artifacts.CONFIG.items.heliumFlamingoCooldown)));
    public static final Holder<Item> CHORUS_TOTEM = ModItems.wearableItem("chorus_totem", builder -> builder.component(ModDataComponents.DEATH_PROTECTION_TELEPORT.get(), new DeathProtectionTeleport(Artifacts.CONFIG.items.chorusTotemTeleportationChance, Artifacts.CONFIG.items.chorusTotemHealthRestored, Artifacts.CONFIG.items.chorusTotemCooldown, Artifacts.CONFIG.items.chorusTotemConsumeOnUse)));
    public static final Holder<Item> WARP_DRIVE = ModItems.wearableItem("warp_drive", builder -> builder.component(ModDataComponents.ENDER_PEARL_HUNGER_COST.get(), new EnderPearlHungerCost(Artifacts.CONFIG.items.warpDriveEnabled, Artifacts.CONFIG.items.warpDriveHungerCost, Artifacts.CONFIG.items.warpDriveCooldown)).component(ModDataComponents.ENDER_PEARL_DAMAGE_IMMUNITY.get(), Artifacts.CONFIG.items.warpDriveNullifyEnderPearlDamage));
    public static final Holder<Item> DIGGING_CLAWS = ModItems.wearableItem("digging_claws", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE).addAttributeModifier((Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, Artifacts.CONFIG.items.diggingClawsBlockBreakSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).component(ModDataComponents.TOOL_TIER_UPGRADE.get(), new ToolTierUpgrade(Artifacts.CONFIG.items.diggingClawsToolTier)));
    public static final Holder<Item> FERAL_CLAWS = ModItems.wearableItem("feral_claws", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE).addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, Artifacts.CONFIG.items.feralClawsAttackSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> POWER_GLOVE = ModItems.wearableItem("power_glove", builder -> builder.addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, Artifacts.CONFIG.items.powerGloveAttackDamageBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> FIRE_GAUNTLET = ModItems.wearableItem("fire_gauntlet", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON).addAttributeModifier(ModAttributes.ATTACK_BURNING_DURATION, Artifacts.CONFIG.items.fireGauntletFireDuration, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> POCKET_PISTON = ModItems.wearableItem("pocket_piston", builder -> builder.equipSound(SoundEvents.PISTON_EXTEND).addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, Artifacts.CONFIG.items.pocketPistonAttackKnockbackBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> VAMPIRIC_GLOVE = ModItems.wearableItem("vampiric_glove", builder -> builder.component(ModDataComponents.DAMAGE_ABSORPTION.get(), new DamageAbsorption(Artifacts.CONFIG.items.vampiricGloveAbsorptionRatio, Artifacts.CONFIG.items.vampiricGloveAbsorptionChance, Artifacts.CONFIG.items.vampiricGloveMaxHealingPerHit)));
    public static final Holder<Item> GOLDEN_HOOK = ModItems.wearableItem("golden_hook", builder -> builder.addAttributeModifier(ModAttributes.ENTITY_EXPERIENCE, Artifacts.CONFIG.items.goldenHookEntityExperienceBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).component(ModDataComponents.PIGLIN_LOVED.get()));
    public static final Holder<Item> ONION_RING = ModItems.wearableItem("onion_ring", builder -> builder.properties(properties -> properties.food(new FoodProperties.Builder().nutrition(2).build())).component(ModDataComponents.POST_EATING_EFFECTS.get(), new PostEatingEffects(List.of(new PostEatingEffects.Entry(new MobEffectProvider((Holder<MobEffect>)MobEffects.DIG_SPEED, Artifacts.CONFIG.items.onionRingHasteLevel, Artifacts.CONFIG.items.onionRingHasteDurationPerFoodPoint, Value.of(true), Value.of(true), EntityCondition.ALWAYS))))));
    public static final Holder<Item> PICKAXE_HEATER = ModItems.wearableItem("pickaxe_heater", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON).component(ModDataComponents.AUTO_SMELT.get(), Artifacts.CONFIG.items.pickaxeHeaterEnabled));
    public static final Holder<Item> WITHERED_BRACELET = ModItems.wearableItem("withered_bracelet", builder -> builder.component(ModDataComponents.ATTACK_EFFECTS.get(), new AttackEffects(List.of(new AttackEffects.Entry(new MobEffectProvider((Holder<MobEffect>)MobEffects.WITHER, Artifacts.CONFIG.items.witheredBraceletWitherLevel, Artifacts.CONFIG.items.witheredBraceletWitherDuration, Value.of(true), Value.of(true), EntityCondition.ALWAYS), Artifacts.CONFIG.items.witheredBraceletWitherChance, Artifacts.CONFIG.items.witheredBraceletCooldown)))));
    public static final Holder<Item> AQUA_DASHERS = ModItems.wearableItem("aqua_dashers", builder -> builder.component(ModDataComponents.FLUID_COLLISION.get(), new FluidCollision(Artifacts.CONFIG.items.aquaDashersEnabled, Optional.empty(), EntityCondition.SPRINTING)));
    public static final Holder<Item> BUNNY_HOPPERS = ModItems.wearableItem("bunny_hoppers", builder -> builder.addAttributeModifier((Holder<Attribute>)Attributes.JUMP_STRENGTH, Artifacts.CONFIG.items.bunnyHoppersJumpStrengthBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier((Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, Artifacts.CONFIG.items.bunnyHoppersFallDamageMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, Artifacts.CONFIG.items.bunnyHoppersSafeFallDistanceBonus, AttributeModifier.Operation.ADD_VALUE).component(ModDataComponents.HURT_SOUND.get(), new HurtSound((Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.RABBIT_HURT), Artifacts.CONFIG.items.bunnyHoppersModifyHurtSounds)));
    public static final Holder<Item> KITTY_SLIPPERS = ModItems.wearableItem("kitty_slippers", builder -> builder.equipSound(SoundEvents.CAT_AMBIENT).component(ModDataComponents.CREEPER_REPELLENT.get(), Artifacts.CONFIG.items.kittySlippersRepelCreepers).component(ModDataComponents.PHANTOM_REPELLENT.get(), Artifacts.CONFIG.items.kittySlippersRepelPhantoms).component(ModDataComponents.HURT_SOUND.get(), new HurtSound((Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.CAT_HURT), Artifacts.CONFIG.items.kittySlippersModifyHurtSounds)));
    public static final Holder<Item> RUNNING_SHOES = ModItems.wearableItem("running_shoes", builder -> builder.addAttributeModifier(ModAttributes.SPRINTING_SPEED, Artifacts.CONFIG.items.runningShoesSprintingSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(ModAttributes.SPRINTING_STEP_HEIGHT, Artifacts.CONFIG.items.runningShoesSprintingStepHeightBonus, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> SNOWSHOES = ModItems.wearableItem("snowshoes", builder -> builder.component(ModDataComponents.WALK_ON_POWDER_SNOW.get(), Artifacts.CONFIG.items.snowshoesAllowWalkingOnPowderedSnow).addAttributeModifier(ModAttributes.MOVEMENT_SPEED_ON_SNOW, Artifacts.CONFIG.items.snowshoesMovementSpeedOnSnowBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> STEADFAST_SPIKES = ModItems.wearableItem("steadfast_spikes", builder -> builder.addAttributeModifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, Artifacts.CONFIG.items.steadfastSpikesKnockbackResistance, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(ModAttributes.SLIP_RESISTANCE, Artifacts.CONFIG.items.steadfastSpikesSlipperinessReduction, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<Item> FLIPPERS = ModItems.wearableItem("flippers", builder -> builder.addAttributeModifier(ModAttributes.SWIM_SPEED, Artifacts.CONFIG.items.flippersSwimSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final Holder<Item> ROOTED_BOOTS = ModItems.wearableItem("rooted_boots", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER).component(ModDataComponents.REPLENISH_HUNGER_ON_GRASS.get(), new ReplenishHungerOnGrass(Artifacts.CONFIG.items.rootedBootsEnabled, Artifacts.CONFIG.items.rootedBootsHungerReplenishingDuration)).component(ModDataComponents.POST_EATING_PLANT_GROWTH.get(), Artifacts.CONFIG.items.rootedBootsGrowPlantsAfterEating));
    public static final Holder<Item> STRIDER_SHOES = ModItems.wearableItem("strider_shoes", builder -> builder.equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER).component(ModDataComponents.FLUID_COLLISION.get(), new FluidCollision(Artifacts.CONFIG.items.striderShoesEnabled, Optional.of(FluidTags.LAVA), EntityCondition.SNEAKING)).component(ModDataComponents.DAMAGE_IMMUNITY.get(), new DamageImmunity(Artifacts.CONFIG.items.striderShoesCancelHotFloorDamage, ModTags.IS_HOT_FLOOR, EntityCondition.ALWAYS)));
    public static final Holder<Item> WHOOPEE_CUSHION = ModItems.wearableItem("whoopee_cushion", builder -> builder.equipSound(ModSoundEvents.FART).addAttributeModifier(ModAttributes.FLATULENCE, Artifacts.CONFIG.items.whoopeeCushionFartChance, AttributeModifier.Operation.ADD_VALUE));

    private static Holder<Item> wearableItem(String name, Consumer<WearableArtifactItem.Builder> consumer) {
        return ModItems.register(name, () -> {
            WearableArtifactItem.Builder builder = new WearableArtifactItem.Builder(name);
            consumer.accept(builder);
            return builder.build();
        });
    }

    private static Holder<Item> register(String name, Supplier<? extends Item> supplier) {
        return ITEMS.register(name, supplier);
    }
}

