/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.data;

import artifacts.Artifacts;
import artifacts.config.value.Value;
import artifacts.entity.MimicEntity;
import artifacts.loot.ArtifactRarityAdjustedChance;
import artifacts.loot.ConfigValueCondition;
import artifacts.neoforge.data.EntityEquipment;
import artifacts.neoforge.data.LootModifiers;
import artifacts.registry.ModItems;
import artifacts.world.CampsiteFeature;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class LootTables
extends LootTableProvider {
    public static final ResourceKey<LootTable> CHEST_LOOT = Artifacts.key(Registries.LOOT_TABLE, "chests/campsite_chest");
    private final List<LootTableProvider.SubProviderEntry> tables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final ExistingFileHelper existingFileHelper;
    private final LootModifiers lootModifiers;

    public LootTables(PackOutput packOutput, ExistingFileHelper existingFileHelper, LootModifiers lootModifiers, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(), lookupProvider);
        this.existingFileHelper = existingFileHelper;
        this.lootModifiers = lootModifiers;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.tables.clear();
        this.addDrinkingHatsLootTable();
        this.addItemLootTables();
        this.addArtifactsLootTable();
        this.addChestLootTables();
        new EntityEquipment(this).addLootTables();
        for (LootModifiers.Builder lootBuilder : this.lootModifiers.lootBuilders) {
            this.addLootTable("inject/" + lootBuilder.getName(), provider -> lootBuilder.createLootTable(), lootBuilder.getParameterSet());
        }
        this.addLootTable(MimicEntity.LOOT_TABLE.location().getPath(), new LootTable.Builder().withPool(new LootPool.Builder().add(LootTables.artifact(1))));
        return this.tables;
    }

    private void addArtifactsLootTable() {
        ArrayList items = new ArrayList();
        BuiltInRegistries.ITEM.stream().filter(item -> BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("artifacts")).filter(item -> item != ModItems.MIMIC_SPAWN_EGG.value()).sorted(Comparator.comparing(item -> BuiltInRegistries.ITEM.getKey(item).getPath())).forEach(items::add);
        items.removeAll(List.of((Item)ModItems.MIMIC_SPAWN_EGG.value(), (Item)ModItems.NOVELTY_DRINKING_HAT.value(), (Item)ModItems.PLASTIC_DRINKING_HAT.value(), (Item)ModItems.WHOOPEE_CUSHION.value(), (Item)ModItems.HELIUM_FLAMINGO.value(), (Item)ModItems.ETERNAL_STEAK.value(), (Item)ModItems.EVERLASTING_BEEF.value(), (Item)ModItems.UMBRELLA.value()));
        LootPool.Builder builder = LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        items.forEach(item -> builder.add(LootTables.itemWhenEnabled(item, 8)));
        builder.add(LootTables.drinkingHatWhenEnabled(8)).add(LootTables.itemWhenEnabled((Item)ModItems.UMBRELLA.value(), 5)).add(LootTables.itemWhenEnabled((Item)ModItems.WHOOPEE_CUSHION.value(), 5)).add(LootTables.itemWhenEnabled((Item)ModItems.HELIUM_FLAMINGO.value(), 4)).add(LootTables.itemWhenEnabled((Item)ModItems.EVERLASTING_BEEF.value(), 2));
        this.addLootTable("artifact", LootTable.lootTable().withPool(builder));
    }

    private void addDrinkingHatsLootTable() {
        this.addLootTable("items/drinking_hat", LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PLASTIC_DRINKING_HAT.value())).setWeight(3).when(ConfigValueCondition.canGenerateAsLoot((Item)ModItems.PLASTIC_DRINKING_HAT.value())), EmptyLootItem.emptyItem().setWeight(3)})).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.NOVELTY_DRINKING_HAT.value())).setWeight(1).when(ConfigValueCondition.canGenerateAsLoot((Item)ModItems.NOVELTY_DRINKING_HAT.value())), EmptyLootItem.emptyItem().setWeight(1)}))));
    }

    private void addItemLootTables() {
        for (Holder holder : ModItems.ITEMS.getEntries()) {
            if (List.of((Item)ModItems.MIMIC_SPAWN_EGG.value(), (Item)ModItems.ETERNAL_STEAK.value(), (Item)ModItems.PLASTIC_DRINKING_HAT.value(), (Item)ModItems.NOVELTY_DRINKING_HAT.value()).contains(holder.value())) continue;
            this.addLootTable("items/%s".formatted(((ResourceKey)holder.unwrapKey().orElseThrow()).location().getPath()), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)((ItemLike)holder.value())).setWeight(1).when(ConfigValueCondition.canGenerateAsLoot((Item)holder.value())), EmptyLootItem.emptyItem().setWeight(1)}))));
        }
    }

    private void addChestLootTables() {
        String barrel = CampsiteFeature.BARREL_LOOT.location().getPath();
        this.addLootTable(barrel, new LootTable.Builder().withPool(new LootPool.Builder().when(LootItemRandomChanceCondition.randomChance((float)0.7f)).add((LootPoolEntryContainer.Builder)LootTables.item(Items.COD, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.SALMON, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.ROTTEN_FLESH, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.BONE, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)10.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.PAPER, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.SUGAR_CANE, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.WHEAT, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.BOOK, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.SUGAR, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootTables.item(Items.COAL, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add(LootTables.lootTable(barrel + "/tnt", 1)).add(LootTables.lootTable(barrel + "/cobwebs", 1)).add(LootTables.lootTable(barrel + "/ores", 1)).add(LootTables.lootTable(barrel + "/ingots", 1)).add(LootTables.lootTable(barrel + "/gems", 1)).add(LootTables.lootTable(barrel + "/crops", 1)).add(LootTables.lootTable(barrel + "/food", 1)).add(LootTables.lootTable(barrel + "/cobblestone", 1)).add(LootTables.lootTable(barrel + "/rails", 1)).add(LootTables.lootTable(barrel + "/minecarts", 1))));
        this.addLootTable(barrel + "/tnt", new LootTable.Builder().withPool(new LootPool.Builder().name("tnt").setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add(LootTables.item(Items.TNT, 1)).add(LootTables.item(Items.GUNPOWDER, 4, 1, 5))).withPool(new LootPool.Builder().name("sand").add(LootTables.item(Items.SAND, 2, 8, 40)).add(LootTables.item(Items.RED_SAND, 1, 8, 40))));
        this.addLootTable(barrel + "/cobwebs", new LootTable.Builder().withPool(new LootPool.Builder().add(LootTables.item(Items.COBWEB, 1, 3, 8))).withPool(new LootPool.Builder().add(LootTables.item(Items.STRING, 1, 6, 16))));
        this.addLootTable(barrel + "/ores", new LootTable.Builder().withPool(new LootPool.Builder().name("ores").setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add(LootTables.item(Items.RAW_GOLD, 1, 4, 20)).add(LootTables.item(Items.RAW_IRON, 1, 4, 20)).add(LootTables.item(Items.RAW_COPPER, 1, 4, 20))).withPool(new LootPool.Builder().name("blocks").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTables.item(Items.RAW_GOLD_BLOCK, 1, 2, 8)).add(LootTables.item(Items.RAW_IRON_BLOCK, 1, 2, 8)).add(LootTables.item(Items.RAW_COPPER_BLOCK, 1, 2, 8))));
        this.addLootTable(barrel + "/ingots", new LootTable.Builder().withPool(new LootPool.Builder().name("ingots").setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add(LootTables.item(Items.GOLD_INGOT, 1, 4, 16)).add(LootTables.item(Items.IRON_INGOT, 1, 4, 16)).add(LootTables.item(Items.COPPER_INGOT, 1, 4, 16))).withPool(new LootPool.Builder().name("blocks").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTables.item(Items.GOLD_BLOCK, 1, 1, 6)).add(LootTables.item(Items.IRON_BLOCK, 1, 1, 6)).add(LootTables.item(Items.COPPER_BLOCK, 1, 4, 16))));
        this.addLootTable(barrel + "/gems", new LootTable.Builder().withPool(new LootPool.Builder().setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add(LootTables.item(Items.AMETHYST_SHARD, 3, 1, 8)).add(LootTables.item(Items.DIAMOND, 1, 1, 4)).add(LootTables.item(Items.EMERALD, 1, 1, 4))));
        this.addLootTable(barrel + "/crops", new LootTable.Builder().withPool(new LootPool.Builder().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add(LootTables.item(Items.POTATO, 1, 2, 12)).add(LootTables.item(Items.CARROT, 1, 2, 12)).add(LootTables.item(Items.BEETROOT, 1, 2, 12)).add(LootTables.item(Items.WHEAT, 1, 2, 12)).add(LootTables.item(Items.MELON_SLICE, 1, 2, 12)).add(LootTables.item(Items.PUMPKIN, 1, 2, 12)).add(LootTables.item(Items.APPLE, 1, 2, 12))));
        this.addLootTable(barrel + "/food", new LootTable.Builder().withPool(new LootPool.Builder().setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add(LootTables.item(Items.BREAD, 1, 2, 12)).add(LootTables.item(Items.PUMPKIN_PIE, 1, 2, 12)).add(LootTables.item(Items.CAKE, 1)).add(LootTables.item(Items.COOKIE, 1, 2, 12)).add(LootTables.item(Items.MUSHROOM_STEW, 1, 1, 4)).add(LootTables.item(Items.RABBIT_STEW, 1, 1, 4))));
        this.addLootTable(barrel + "/cobblestone", new LootTable.Builder().withPool(new LootPool.Builder().setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add(LootTables.item(Items.COBBLESTONE, 1, 16, 64)).add(LootTables.item(Items.COBBLED_DEEPSLATE, 1, 16, 64))));
        this.addLootTable(barrel + "/rails", new LootTable.Builder().withPool(new LootPool.Builder().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).add(LootTables.item(Items.RAIL, 4, 4, 16)).add(LootTables.item(Items.ACTIVATOR_RAIL, 1, 2, 5)).add(LootTables.item(Items.DETECTOR_RAIL, 1, 2, 5)).add(LootTables.item(Items.POWERED_RAIL, 2, 4, 16))));
        this.addLootTable(barrel + "/minecarts", new LootTable.Builder().withPool(new LootPool.Builder().name("minecarts").setRolls((NumberProvider)ConstantValue.exactly((float)5.0f)).add(LootTables.item(Items.MINECART, 4)).add(LootTables.item(Items.CHEST_MINECART, 1)).add(LootTables.item(Items.FURNACE_MINECART, 1)).add(LootTables.item(Items.HOPPER_MINECART, 1))).withPool(new LootPool.Builder().name("rails").add(LootTables.item(Items.RAIL, 1, 4, 16))));
        this.addLootTable(CHEST_LOOT.location().getPath(), (HolderLookup.Provider provider) -> new LootTable.Builder().withPool(new LootPool.Builder().name("tools").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add(LootTables.item(Items.DIAMOND_PICKAXE, 2)).add(LootTables.item(Items.DIAMOND_AXE, 1)).add(LootTables.item(Items.DIAMOND_SHOVEL, 1)).add(LootTables.item(Items.GOLDEN_PICKAXE, 4)).add(LootTables.item(Items.GOLDEN_AXE, 2)).add(LootTables.item(Items.GOLDEN_SHOVEL, 2)).add(LootTables.item(Items.IRON_PICKAXE, 6)).add(LootTables.item(Items.IRON_AXE, 3)).add(LootTables.item(Items.IRON_SHOVEL, 3)).add(LootTables.item(Items.IRON_HELMET, 2)).add(LootTables.item(Items.IRON_CHESTPLATE, 2)).add(LootTables.item(Items.IRON_LEGGINGS, 2)).add(LootTables.item(Items.IRON_BOOTS, 2)).add(LootTables.item(Items.CHAINMAIL_HELMET, 1)).add(LootTables.item(Items.CHAINMAIL_CHESTPLATE, 1)).add(LootTables.item(Items.CHAINMAIL_LEGGINGS, 1)).add(LootTables.item(Items.CHAINMAIL_BOOTS, 1))).withPool(new LootPool.Builder().name("junk").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)).add(LootTables.item(Items.GUNPOWDER, 5, 2, 8)).add(LootTables.item(Items.ROTTEN_FLESH, 5, 2, 8)).add(LootTables.item(Items.SPIDER_EYE, 5, 2, 8)).add(LootTables.item(Items.STRING, 5, 2, 8)).add(LootTables.item(Items.PAPER, 5, 2, 8)).add(LootTables.item(Items.BONE, 5, 2, 8)).add(LootTables.item(Items.STICK, 3, 2, 8)).add(LootTables.item(Items.GLASS_BOTTLE, 3, 2, 8)).add(LootTables.item(Items.LEATHER, 3, 2, 8)).add(LootTables.item(Items.FLINT, 3, 2, 8)).add(LootTables.item(Items.FEATHER, 3, 2, 8))).withPool(new LootPool.Builder().name("ores").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)).add(LootTables.item(Items.RAW_COPPER, 3, 2, 8)).add(LootTables.item(Items.RAW_IRON, 3, 2, 8)).add(LootTables.item(Items.RAW_GOLD, 3, 2, 8)).add(LootTables.item(Items.COAL, 6, 4, 8)).add(LootTables.item(Items.DIAMOND, 1, 1, 4))).withPool(new LootPool.Builder().name("treasure").when(LootItemRandomChanceCondition.randomChance((float)0.3f)).add((LootPoolEntryContainer.Builder)LootTables.item(Items.BOOK, 8).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)15.0f, (float)30.0f)))).add(LootTables.item(Items.GOLDEN_APPLE, 4)).add(LootTables.item(Items.ENCHANTED_GOLDEN_APPLE, 1))).withPool(new LootPool.Builder().name("artifact").when(ArtifactRarityAdjustedChance.adjustedChance(0.15f)).add(LootTables.artifact(1))));
    }

    protected static LootPoolEntryContainer.Builder<?> itemWhenEnabled(Item item, int weight) {
        return LootTables.item(item, weight).when(ConfigValueCondition.canGenerateAsLoot(item));
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight) {
        Value<Boolean> generatesAsLoot = Artifacts.CONFIG.items.generatesAsLoot(item);
        if (generatesAsLoot == null) {
            return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
        }
        if (item == ModItems.PLASTIC_DRINKING_HAT.value() || item == ModItems.NOVELTY_DRINKING_HAT.value()) {
            throw new IllegalArgumentException();
        }
        String itemName = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        return NestedLootTable.lootTableReference(Artifacts.key(Registries.LOOT_TABLE, "items/%s".formatted(itemName))).setWeight(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight, int min, int max) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
    }

    protected static LootPoolEntryContainer.Builder<?> artifact(int weight) {
        return LootTables.lootTable("artifact", weight);
    }

    protected static LootPoolEntryContainer.Builder<?> drinkingHat(int weight) {
        return LootTables.lootTable("items/drinking_hat", weight);
    }

    protected static LootPoolEntryContainer.Builder<?> drinkingHatWhenEnabled(int weight) {
        return LootTables.lootTable("items/drinking_hat", weight).when((LootItemCondition.Builder)ConfigValueCondition.canGenerateAsLoot((Item)ModItems.PLASTIC_DRINKING_HAT.value()).or(ConfigValueCondition.canGenerateAsLoot((Item)ModItems.NOVELTY_DRINKING_HAT.value())));
    }

    private static LootPoolEntryContainer.Builder<?> lootTable(String lootTable, int weight) {
        return NestedLootTable.lootTableReference(Artifacts.key(Registries.LOOT_TABLE, lootTable)).setWeight(weight);
    }

    public void addLootTable(String location, Function<HolderLookup.Provider, LootTable.Builder> lootTable, LootContextParamSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(ResourceLocation.parse((String)(Registries.LOOT_TABLE.location().getPath() + "/" + actualLocation + ".json")), PackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
        }
        this.tables.add(new LootTableProvider.SubProviderEntry(provider -> biConsumer -> biConsumer.accept(Artifacts.key(Registries.LOOT_TABLE, location), (LootTable.Builder)lootTable.apply((HolderLookup.Provider)provider)), lootParameterSet));
    }

    private void addLootTable(String location, Function<HolderLookup.Provider, LootTable.Builder> lootTable) {
        this.addLootTable(location, lootTable, LootContextParamSets.ALL_PARAMS);
    }

    private void addLootTable(String location, LootTable.Builder lootTable) {
        this.addLootTable(location, provider -> lootTable, LootContextParamSets.ALL_PARAMS);
    }
}

