/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public record DamageAbsorption(Value<Double> absorptionRatio, Value<Double> absorptionChance, Value<Integer> maxDamageAbsorbed) implements EquipmentAbility
{
    public static final Codec<DamageAbsorption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().fieldOf("absorption_ratio").forGetter(DamageAbsorption::absorptionRatio), (App)ValueTypes.FRACTION.codec().fieldOf("absorption_chance").forGetter(DamageAbsorption::absorptionChance), (App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("max_damage_absorbed").forGetter(DamageAbsorption::maxDamageAbsorbed)).apply((Applicative)instance, DamageAbsorption::new));
    public static final StreamCodec<ByteBuf, DamageAbsorption> STREAM_CODEC = StreamCodec.composite(ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), DamageAbsorption::absorptionRatio, ValueTypes.FRACTION.streamCodec(), DamageAbsorption::absorptionChance, ValueTypes.NON_NEGATIVE_INT.streamCodec(), DamageAbsorption::maxDamageAbsorbed, DamageAbsorption::new);

    @Override
    public boolean isNonCosmetic() {
        return (Double)this.absorptionRatio.get() > 0.0 && (Double)this.absorptionChance.get() > 0.0 && (Integer)this.maxDamageAbsorbed.get() > 0;
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (Mth.equal((double)((Double)this.absorptionChance.get()), (double)1.0)) {
            writer.add("constant", new Object[0]);
        } else {
            writer.add("chance", Math.round((Double)this.absorptionChance.get() * 100.0));
        }
    }
}

