/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.timcore.command;

import com.cobblemon.mod.common.api.permission.PermissionLevel;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.timcore.AbstractCommand;
import us.timinc.mc.cobblemon.timcore.PokemonMatcher;
import us.timinc.mc.cobblemon.timcore.TimCore;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\r\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lus/timinc/mc/cobblemon/timcore/command/PokemonMatcherTestCommand;", "Lus/timinc/mc/cobblemon/timcore/AbstractCommand;", "Lus/timinc/mc/cobblemon/timcore/command/PokemonMatcherTestCommand$Data;", "<init>", "()V", "commandContext", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "rawContext", "", "run", "(Lus/timinc/mc/cobblemon/timcore/command/PokemonMatcherTestCommand$Data;Lcom/mojang/brigadier/context/CommandContext;)I", "ctx", "parseContext", "(Lcom/mojang/brigadier/context/CommandContext;)Lus/timinc/mc/cobblemon/timcore/command/PokemonMatcherTestCommand$Data;", "Data", "common"})
public final class PokemonMatcherTestCommand
extends AbstractCommand<Data> {
    @NotNull
    public static final PokemonMatcherTestCommand INSTANCE = new PokemonMatcherTestCommand();

    private PokemonMatcherTestCommand() {
        Object[] objectArray = new RequiredArgumentBuilder[]{Commands.argument((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)6))), Commands.argument((String)"matcher", (ArgumentType)((ArgumentType)StringArgumentType.greedyString()))};
        super("pokemon_matcher_test", PermissionLevel.ALL_COMMANDS, TimCore.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, 16, null);
    }

    @Override
    public int run(@NotNull Data commandContext, @NotNull CommandContext<CommandSourceStack> rawContext) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"commandContext");
        Intrinsics.checkNotNullParameter(rawContext, (String)"rawContext");
        ServerPlayer serverPlayer = ((CommandSourceStack)rawContext.getSource()).getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        Pokemon pokemon = PlayerExtensionsKt.party((ServerPlayer)player).get(commandContext.getSlot() - 1);
        if (pokemon == null) {
            PokemonMatcherTestCommand $this$run_u24lambda_u240 = this;
            boolean bl = false;
            player.sendSystemMessage((Component)Component.translatable((String)("Invalid party slot " + commandContext.getSlot() + ".")));
            return 0;
        }
        Pokemon teamMember = pokemon;
        if (PokemonMatcher.Companion.parse(commandContext.getMatcher()).matches(teamMember)) {
            player.sendSystemMessage((Component)Component.translatable((String)((TimCore.Config)TimCore.INSTANCE.getConfig()).getSuccessKey()));
            return 1;
        }
        player.sendSystemMessage((Component)Component.translatable((String)((TimCore.Config)TimCore.INSTANCE.getConfig()).getFailureKey()));
        return 0;
    }

    @Override
    @NotNull
    public Data parseContext(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        int n = IntegerArgumentType.getInteger(ctx, (String)"slot");
        String string = StringArgumentType.getString(ctx, (String)"matcher");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new Data(n, string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lus/timinc/mc/cobblemon/timcore/command/PokemonMatcherTestCommand$Data;", "", "", "slot", "", "matcher", "<init>", "(ILjava/lang/String;)V", "I", "getSlot", "()I", "Ljava/lang/String;", "getMatcher", "()Ljava/lang/String;", "common"})
    public static final class Data {
        private final int slot;
        @NotNull
        private final String matcher;

        public Data(int slot, @NotNull String matcher) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            this.slot = slot;
            this.matcher = matcher;
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final String getMatcher() {
            return this.matcher;
        }
    }
}

