/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.spawner;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.AlphaGenerator;
import dev.cudzer.cobblemonalphas.entity.HerdMember;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaDespawner;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.ISpawnLocation;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.RandomSpawnAroundPlayer;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.BlockBlacklist;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.HeightBounds;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.ISpawnCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class AlphaSpawner {
    private static final AlphaSpawner instance = new AlphaSpawner();
    private static final Random RNG = new Random();
    private int spawnCountdown;
    private ISpawnLocation spawnLocationSelector;
    private List<ISpawnCondition> spawnConditions;
    private static final int HERD_SIZE = 4;
    private MinecraftServer server;

    public static AlphaSpawner getInstance() {
        return instance;
    }

    public void init() {
        this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        this.spawnLocationSelector = new RandomSpawnAroundPlayer(ModConfig.minimumSpawnDistance, ModConfig.maximumSpawnDistance);
        this.spawnConditions = List.of(new BlockBlacklist(List.of(Blocks.LAVA, Blocks.FIRE, Blocks.CACTUS)), new HeightBounds(-50, 200));
        AlphaDespawner.getInstance().setMinimumDespawnDistance(ModConfig.minimumSpawnDistance);
        AlphaDespawner.getInstance().setSpawnIntervalTicks(ModConfig.ticksBetweenSpawns);
        AlphaJsonDataManager.populateBiomeData(this.server.getLevel(Level.OVERWORLD));
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (this.spawnCountdown > 0) {
            --this.spawnCountdown;
        } else {
            this.attemptSpawn();
            this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        }
    }

    private void attemptSpawn() {
        Map<ResourceLocation, Alpha> alphaMap;
        Vec3i spawnLocation;
        Level spawnLevel;
        List players = this.server.getPlayerList().getPlayers();
        if (players.size() < ModConfig.requiredPlayerAmount) {
            return;
        }
        if (RNG.nextDouble() > (double)(ModConfig.alphaSpawnChance + 0.02f * (float)(this.server.getPlayerCount() - ModConfig.requiredPlayerAmount))) {
            return;
        }
        int attemptedSpawns = 0;
        while (true) {
            boolean underground;
            Optional biomeKey;
            if (++attemptedSpawns > ModConfig.spawnAttempts) {
                CobblemonAlphasMod.LOGGER.info("Maximum spawn attempts reached. Skipping this alpha spawn");
                return;
            }
            Optional chosenPlayerOpt = players.stream().skip((int)((double)players.size() * RNG.nextDouble())).findFirst();
            if (!chosenPlayerOpt.isPresent()) continue;
            ServerPlayer chosenPlayer = (ServerPlayer)chosenPlayerOpt.get();
            spawnLevel = chosenPlayer.level();
            Level chosenPlayerSpawnLevel = chosenPlayer.level();
            spawnLocation = this.spawnLocationSelector.getSpawnLocation(chosenPlayer.level(), chosenPlayer.position());
            if (spawnLocation == null) continue;
            BlockPos finalSpawnPos = new BlockPos(spawnLocation.getX(), spawnLocation.getY(), spawnLocation.getZ());
            if (this.spawnConditions.stream().anyMatch(condition -> !condition.isSafe(chosenPlayerSpawnLevel, finalSpawnPos)) || (biomeKey = chosenPlayerSpawnLevel.getBiome(finalSpawnPos).unwrapKey()).isEmpty()) continue;
            boolean bl = underground = !spawnLevel.canSeeSky(finalSpawnPos);
            alphaMap = AlphaJsonDataManager.getRandomAlphaForBiome(spawnLevel, (ResourceKey<Biome>)((ResourceKey)biomeKey.get()), underground);
            if (alphaMap != null && !alphaMap.isEmpty()) break;
        }
        Alpha chosenAlpha = alphaMap.values().iterator().next();
        Vec3i spawnPos = spawnLocation;
        this.spawnAlphaEntity(chosenAlpha, spawnLevel, spawnPos, ModConfig.doHerdSpawning);
        Object announcement = ModConfig.spawnAnnouncementMessage;
        if (ModConfig.showCoordinatesInAnnouncement) {
            announcement = (String)announcement + " (" + spawnPos.getX() + ", " + spawnPos.getY() + ", " + spawnPos.getZ() + ")";
        }
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)announcement), false);
    }

    public void spawnAlphaEntity(Alpha alpha, Level level, Vec3i spawnPosition, boolean doHerdSpawning) {
        if (!level.isClientSide()) {
            PokemonEntity alphaEntity = AlphaGenerator.generate(alpha, level, spawnPosition);
            if (alphaEntity != null) {
                level.getChunkAt(new BlockPos(spawnPosition));
                level.addFreshEntity((Entity)alphaEntity);
                if (doHerdSpawning) {
                    this.spawnHerdPokemon(alphaEntity, alpha.getHerdMembers(), level, spawnPosition);
                }
            } else {
                CobblemonAlphasMod.LOGGER.error("An alpha spawn was attempted but the entity creation failed...");
            }
        }
    }

    private void spawnHerdPokemon(PokemonEntity alphaEntity, List<HerdMember> herdMembers, Level spawnLevel, Vec3i spawnPos) {
        String alphaString = alphaEntity.getPokemon().getSpecies().getName();
        if (herdMembers.size() <= 0) {
            CobblemonAlphasMod.LOGGER.warn(String.format("Herd members for %s is empty. Skipping herd spawning for this alpha", alphaString));
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            HerdMember herdMember = herdMembers.get(RNG.nextInt(herdMembers.size()));
            Pokemon herdMemberPokemon = new Pokemon();
            Species herdMemberSpecies = PokemonSpecies.getByName((String)herdMember.getSpecies());
            if (herdMemberSpecies == null) {
                CobblemonAlphasMod.LOGGER.warn(String.format("Incorrect species defined for herd member of %s. %s is not a valid pokemon species", alphaString, herdMember.getSpecies()));
                return;
            }
            herdMemberPokemon.setSpecies(herdMemberSpecies);
            herdMemberPokemon.setLevel(herdMember.getLevelFromRange());
            herdMemberPokemon.initializeMoveset(true);
            herdMemberPokemon.getPersistentData().putUUID("ALPHA_ID", alphaEntity.getUUID());
            if (RNG.nextDouble() < 1.0 / (double)ModConfig.shinyOdds) {
                herdMemberPokemon.setShiny(true);
            }
            PokemonEntity herdEntity = new PokemonEntity(spawnLevel, herdMemberPokemon, CobblemonEntities.POKEMON);
            herdEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
            herdEntity.setPos((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
            spawnLevel.getChunkAt(new BlockPos(spawnPos));
            spawnLevel.addFreshEntity((Entity)herdEntity);
        }
    }
}

