/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.behavior;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;

public class PokemonFollowAlphaBehavior
extends Behavior<PokemonEntity> {
    private PokemonEntity alphaEntity;
    private int recalcTimer = 0;

    public PokemonFollowAlphaBehavior() {
        super(Map.of());
    }

    protected void start(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.recalcTimer = 0;
    }

    protected boolean canStillUse(ServerLevel level, PokemonEntity entity, long gameTime) {
        return this.alphaEntity != null && !this.alphaEntity.isBattling();
    }

    protected void stop(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.alphaEntity = null;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PokemonEntity entity) {
        this.alphaEntity = HerdUtils.findAlpha(entity);
        if (this.alphaEntity == null) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double dist = entity.distanceToSqr((Entity)this.alphaEntity);
        return dist > 9.0 && dist < 256.0;
    }

    public void tick(ServerLevel level, PokemonEntity entity, long gameTime) {
        if (--this.recalcTimer <= 0) {
            this.recalcTimer = 10;
            entity.getNavigation().moveTo((Entity)this.alphaEntity, 1.1);
        }
    }
}

