/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.behavior;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;

public class HerdMemberRegroupBehavior
extends Behavior<PokemonEntity> {
    private PokemonEntity alphaEntity;
    private int pathCooldown = 0;

    public HerdMemberRegroupBehavior() {
        super(Map.of());
    }

    protected void start(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.pathCooldown = 0;
    }

    protected boolean canStillUse(ServerLevel level, PokemonEntity entity, long gameTime) {
        if (this.alphaEntity == null) {
            return false;
        }
        if (!this.alphaEntity.isAlive()) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double distSq = entity.distanceToSqr((Entity)this.alphaEntity);
        return distSq > 16.0;
    }

    protected void stop(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.alphaEntity = null;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PokemonEntity entity) {
        this.alphaEntity = HerdUtils.findAlpha(entity);
        if (this.alphaEntity == null) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double distSq = entity.distanceToSqr((Entity)this.alphaEntity);
        return !(distSq < 20.0);
    }

    public void tick(ServerLevel level, PokemonEntity entity, long gameTime) {
        if (--this.pathCooldown <= 0) {
            this.pathCooldown = 10;
            entity.getNavigation().moveTo((Entity)this.alphaEntity, 1.2);
        }
    }
}

