/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.behavior;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HerdMemberFleeBehavior
extends Behavior<PokemonEntity> {
    private final double speed;
    private double x;
    private double y;
    private double z;
    private int pathCooldown = 0;
    @Nullable
    private PokemonEntity alpha;

    public HerdMemberFleeBehavior(double speedModifier) {
        super(Map.of());
        this.speed = speedModifier;
    }

    protected void start(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.pathCooldown = 0;
    }

    protected boolean canStillUse(ServerLevel level, PokemonEntity entity, long gameTime) {
        return this.alpha != null && this.alpha.isBattling() && !entity.getNavigation().isDone();
    }

    protected void stop(ServerLevel level, PokemonEntity entity, long gameTime) {
        this.alpha = null;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PokemonEntity entity) {
        this.alpha = HerdUtils.findAlpha(entity);
        if (this.alpha == null) {
            return false;
        }
        if (!this.alpha.isBattling()) {
            return false;
        }
        return this.findRandomPosition(entity);
    }

    private boolean findRandomPosition(PokemonEntity entity) {
        Vec3 pos = DefaultRandomPos.getPos((PathfinderMob)entity, (int)12, (int)6);
        if (pos == null) {
            return false;
        }
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        return true;
    }

    public void tick(ServerLevel level, PokemonEntity entity, long gameTime) {
        if (--this.pathCooldown <= 0) {
            this.pathCooldown = 20;
            entity.getNavigation().moveTo(this.x, this.y, this.z, this.speed);
        }
    }
}

