/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class AlphaJsonDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    protected static Map<ResourceLocation, Alpha> data = new HashMap<ResourceLocation, Alpha>();
    protected static List<ResourceLocation> resourceLocationList = new ArrayList<ResourceLocation>();
    protected static Map<ResourceKey<Biome>, Map<ResourceLocation, Alpha>> biomeData = new HashMap<ResourceKey<Biome>, Map<ResourceLocation, Alpha>>();
    protected static Map<ResourceKey<Biome>, List<ResourceLocation>> resourceLocationMap = new HashMap<ResourceKey<Biome>, List<ResourceLocation>>();
    protected static List<ResourceLocation> undergroundSpawnResourceLocationList = new ArrayList<ResourceLocation>();
    protected static Map<ResourceLocation, Alpha> undergroundSpawnsMap = new HashMap<ResourceLocation, Alpha>();
    protected static Map<ResourceKey<Biome>, List<ResourceLocation>> undergroundResourceLocationMap = new HashMap<ResourceKey<Biome>, List<ResourceLocation>>();
    protected static Map<ResourceKey<Biome>, Map<ResourceLocation, Alpha>> undergroundBiomeData = new HashMap<ResourceKey<Biome>, Map<ResourceLocation, Alpha>>();

    public AlphaJsonDataManager() {
        super(GSON, CobblemonAlphasMod.cobblemonAlphasResource("alphas").getPath());
    }

    public static Map<ResourceLocation, Alpha> getRandomAlphaForBiome(Level level, ResourceKey<Biome> biome, boolean undergroundSpawn) {
        if (!undergroundSpawn) {
            HashMap<ResourceLocation, Alpha> map = new HashMap<ResourceLocation, Alpha>();
            ResourceLocation rl = AlphaJsonDataManager.getRandomResourceLocationForBiome(level, biome);
            Map<ResourceLocation, Alpha> alphaMap = biomeData.getOrDefault(biome, new HashMap());
            Alpha alpha = alphaMap.getOrDefault(rl, null);
            if (alpha == null) {
                alphaMap = AlphaJsonDataManager.getRandomAlpha(level);
                if (alphaMap == null) {
                    CobblemonAlphasMod.LOGGER.error("Something went wrong when trying to choose an alpha to spawn!");
                    return Map.of();
                }
                rl = (ResourceLocation)alphaMap.keySet().stream().toList().getFirst();
                alpha = alphaMap.values().stream().toList().getFirst();
            }
            map.put(rl, alpha);
            return map;
        }
        HashMap<ResourceLocation, Alpha> map = new HashMap<ResourceLocation, Alpha>();
        ResourceLocation rl = AlphaJsonDataManager.getRandomUndergroundResourceLocationForBiome(level, biome);
        Map<ResourceLocation, Alpha> alphaMap = undergroundBiomeData.getOrDefault(biome, new HashMap());
        Alpha alpha = alphaMap.getOrDefault(rl, null);
        if (alpha == null) {
            alphaMap = AlphaJsonDataManager.getRandomUndergroundAlpha(level);
            rl = (ResourceLocation)alphaMap.keySet().stream().toList().getFirst();
            alpha = alphaMap.values().stream().toList().getFirst();
        }
        map.put(rl, alpha);
        return map;
    }

    private static ResourceLocation getRandomResourceLocationForBiome(Level level, ResourceKey<Biome> biome) {
        List resourceLocations = resourceLocationMap.getOrDefault(biome, Collections.emptyList());
        if (resourceLocations.isEmpty()) {
            return AlphaJsonDataManager.getRandomResourceLocation(level);
        }
        return (ResourceLocation)resourceLocations.get(level.random.nextInt(resourceLocations.size()));
    }

    private static ResourceLocation getRandomUndergroundResourceLocationForBiome(Level level, ResourceKey<Biome> biome) {
        List resourceLocations = undergroundResourceLocationMap.getOrDefault(biome, Collections.emptyList());
        if (resourceLocations.isEmpty()) {
            return AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
        }
        return (ResourceLocation)resourceLocations.get(level.random.nextInt(resourceLocations.size()));
    }

    public static Map<ResourceLocation, Alpha> getRandomAlpha(Level level) {
        HashMap<ResourceLocation, Alpha> map = new HashMap<ResourceLocation, Alpha>();
        ResourceLocation rl = AlphaJsonDataManager.getRandomResourceLocation(level);
        if (rl == null) {
            return null;
        }
        Alpha alpha = data.get(rl);
        map.put(rl, alpha);
        return map;
    }

    public static Alpha getAlphaById(ResourceLocation id) {
        return data.get(id);
    }

    public static Map<ResourceLocation, Alpha> getRandomUndergroundAlpha(Level level) {
        HashMap<ResourceLocation, Alpha> map = new HashMap<ResourceLocation, Alpha>();
        ResourceLocation rl = AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
        Alpha alpha = undergroundSpawnsMap.get(rl);
        map.put(rl, alpha);
        return map;
    }

    public static Alpha getRandomAlphaObj(Level level) {
        ResourceLocation rl = AlphaJsonDataManager.getRandomResourceLocation(level);
        if (rl == null) {
            rl = AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
            return undergroundSpawnsMap.get(rl);
        }
        return data.get(rl);
    }

    public static Alpha getAlphaObj(Level level, String alphaName) {
        for (Alpha alpha : data.values()) {
            if (!alpha.getSpecies().equalsIgnoreCase(alphaName)) continue;
            return alpha;
        }
        for (Alpha alpha : undergroundSpawnsMap.values()) {
            if (!alpha.getSpecies().equalsIgnoreCase(alphaName)) continue;
            return alpha;
        }
        return null;
    }

    private static ResourceLocation getRandomResourceLocation(Level level) {
        if (!resourceLocationList.isEmpty()) {
            return resourceLocationList.get(level.random.nextInt(resourceLocationList.size()));
        }
        return null;
    }

    private static ResourceLocation getRandomUndergroundResourceLocation(Level level) {
        return undergroundSpawnResourceLocationList.get(level.random.nextInt(undergroundSpawnResourceLocationList.size()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        CobblemonAlphasMod.LOGGER.info("Loading alpha definitions...");
        HashMap<ResourceLocation, Alpha> newMap = new HashMap<ResourceLocation, Alpha>();
        ArrayList<ResourceLocation> newResourceLocationList = new ArrayList<ResourceLocation>();
        HashMap resourceLocationBiomeMap = new HashMap();
        HashMap<ResourceLocation, Alpha> newUndergroundMap = new HashMap<ResourceLocation, Alpha>();
        ArrayList<ResourceLocation> newUndergroundResourceLocationList = new ArrayList<ResourceLocation>();
        HashMap undergroundLocationBiomeMap = new HashMap();
        data.clear();
        biomeData.clear();
        resourceLocationList.clear();
        undergroundSpawnsMap.clear();
        undergroundSpawnResourceLocationList.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            Alpha.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(result -> {
                Alpha alpha = (Alpha)result.getFirst();
                alpha.setJsonLocation(key);
                if (alpha.canSpawnUnderground()) {
                    newUndergroundMap.put(key, alpha);
                    newUndergroundResourceLocationList.add(key);
                } else {
                    newMap.put(key, alpha);
                    newResourceLocationList.add(key);
                }
                List<ResourceLocation> spawnBiome = alpha.getSpawnBiome();
                spawnBiome.forEach(biome -> {
                    ResourceKey biomeResourceKey = null;
                    try {
                        biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome);
                    }
                    catch (Exception e) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in %s due to %s", biome, key, e));
                    }
                    if (biomeResourceKey == null) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in %s", biome, key));
                    }
                    List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                    resourceLocations.add(key);
                    resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                });
            }).ifError(partial -> CobblemonAlphasMod.LOGGER.error(String.format("Failed to parse data json for %s due to %s", key, partial.message())));
        }
        resourceLocationList = newResourceLocationList;
        data = newMap;
        undergroundSpawnsMap = newUndergroundMap;
        undergroundSpawnResourceLocationList = newUndergroundResourceLocationList;
        CobblemonAlphasMod.LOGGER.info(String.format("Loaded %s alpha definitions.", data.size() + undergroundSpawnsMap.size()));
    }

    public static void populateBiomeData(ServerLevel level) {
        AlphaJsonDataManager.applySurfaceBiomeAlphas((Level)level);
        AlphaJsonDataManager.applyUndergroundBiomeAlphas((Level)level);
    }

    public static Map<ResourceLocation, Alpha> getAlphaData() {
        Map<ResourceLocation, Alpha> newData = data;
        newData.putAll(undergroundSpawnsMap);
        return newData;
    }

    private static void applySurfaceBiomeAlphas(Level level) {
        HashMap<ResourceKey, Map> newBiomeData = new HashMap<ResourceKey, Map>();
        HashMap<ResourceKey, List> resourceLocationBiomeMap = new HashMap<ResourceKey, List>();
        for (Alpha alpha : data.values()) {
            if (alpha.canSpawnUnderground()) continue;
            List<ResourceLocation> tagsResourceLocation = alpha.getSpawnBiomeTags();
            List<ResourceLocation> biomesResourceLocation = alpha.getSpawnBiome();
            for (ResourceLocation tag : tagsResourceLocation) {
                TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag);
                level.registryAccess().registry(Registries.BIOME).ifPresent(reg -> {
                    Iterable biomeHolder = reg.getTagOrEmpty(biomeTagKey);
                    for (Holder biome : biomeHolder) {
                        ResourceKey biomeResourceKey = (ResourceKey)biome.unwrapKey().get();
                        Map mapToPut = newBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                        mapToPut.put(alpha.getJsonLocation(), alpha);
                        newBiomeData.put(biomeResourceKey, mapToPut);
                        List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                        resourceLocations.add(alpha.getJsonLocation());
                        resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                    }
                    if (!biomeHolder.iterator().hasNext()) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Tag for %s does not have any biomes!", biomeTagKey));
                        CobblemonAlphasMod.LOGGER.error(String.format("Alpha for %s might not have any biomes assigned!", alpha.getJsonLocation()));
                    }
                });
            }
            for (ResourceLocation biome : biomesResourceLocation) {
                ResourceKey biomeResourceKey = null;
                try {
                    biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome);
                }
                catch (Exception e) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s due to %s", biome, alpha.getJsonLocation(), e));
                }
                if (biomeResourceKey == null) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s, skipping...", biome, alpha.getJsonLocation()));
                    continue;
                }
                List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                resourceLocations.add(alpha.getJsonLocation());
                resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                Map mapToPut = newBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                mapToPut.put(alpha.getJsonLocation(), alpha);
                newBiomeData.put(biomeResourceKey, mapToPut);
            }
        }
        biomeData.putAll(newBiomeData);
        resourceLocationMap.putAll(resourceLocationBiomeMap);
        newBiomeData.clear();
    }

    private static void applyUndergroundBiomeAlphas(Level level) {
        HashMap<ResourceKey, Map> newUndergroundBiomeData = new HashMap<ResourceKey, Map>();
        HashMap<ResourceKey, List> undergroundLocationBiomeMap = new HashMap<ResourceKey, List>();
        for (Alpha alpha : undergroundSpawnsMap.values()) {
            if (!alpha.canSpawnUnderground()) continue;
            List<ResourceLocation> tagsResourceLocation = alpha.getSpawnBiomeTags();
            List<ResourceLocation> biomesResourceLocation = alpha.getSpawnBiome();
            for (ResourceLocation tag : tagsResourceLocation) {
                TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag);
                level.registryAccess().registry(Registries.BIOME).ifPresent(reg -> {
                    Iterable biomeHolder = reg.getTagOrEmpty(biomeTagKey);
                    for (Holder biome : biomeHolder) {
                        ResourceKey biomeResourceKey = (ResourceKey)biome.unwrapKey().get();
                        Map mapToPut = newUndergroundBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                        mapToPut.put(alpha.getJsonLocation(), alpha);
                        newUndergroundBiomeData.put(biomeResourceKey, mapToPut);
                        List resourceLocations = undergroundLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                        resourceLocations.add(alpha.getJsonLocation());
                        undergroundLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                    }
                    if (!biomeHolder.iterator().hasNext()) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Tag for %s does not have any biomes!", biomeTagKey));
                        CobblemonAlphasMod.LOGGER.error(String.format("Alpha for %s might not have any biomes assigned!", alpha.getJsonLocation()));
                    }
                });
            }
            for (ResourceLocation biome : biomesResourceLocation) {
                ResourceKey biomeResourceKey = null;
                try {
                    biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome);
                }
                catch (Exception e) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s due to %s", biome, alpha.getJsonLocation(), e));
                }
                if (biomeResourceKey == null) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s, skipping...", biome, alpha.getJsonLocation()));
                    continue;
                }
                List resourceLocations = undergroundLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                resourceLocations.add(alpha.getJsonLocation());
                undergroundLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                Map mapToPut = newUndergroundBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                mapToPut.put(alpha.getJsonLocation(), alpha);
                newUndergroundBiomeData.put(biomeResourceKey, mapToPut);
            }
        }
        undergroundBiomeData.putAll(newUndergroundBiomeData);
        undergroundResourceLocationMap.putAll(undergroundLocationBiomeMap);
        newUndergroundBiomeData.clear();
    }
}

