/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.config.ConfigKey;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ModConfig {
    private static Path fullConfigPath;
    public static boolean doAlphaSpawning;
    public static float alphaSpawnChance;
    public static double alphaSizeMultiplier;
    public static int maximumBestIVs;
    public static boolean doHerdSpawning;
    public static int ticksBetweenSpawns;
    public static int spawnAttempts;
    public static int requiredPlayerAmount;
    public static int shinyOdds;
    public static int minimumSpawnDistance;
    public static int maximumSpawnDistance;
    public static String spawnAnnouncementMessage;
    public static boolean showCoordinatesInAnnouncement;

    public static void init(Path baseConfigPath) {
        JsonObject configuration;
        fullConfigPath = baseConfigPath.resolve(ConfigKey.configPath);
        JsonObject defaultConfiguration = new JsonObject();
        ModConfig.addDefaultFields(defaultConfiguration);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            configuration = JsonParser.parseReader((Reader)new FileReader(fullConfigPath.toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            CobblemonAlphasMod.LOGGER.warn("Could not find configuration file");
            configuration = new JsonObject();
        }
        JsonObject finalConfiguration = configuration;
        if (defaultConfiguration.keySet().stream().anyMatch(k -> !finalConfiguration.has(k))) {
            ModConfig.rewriteConfig(gson, defaultConfiguration, finalConfiguration);
        }
        ModConfig.loadConfig(finalConfiguration);
    }

    private static void addDefaultFields(JsonObject defaultConfig) {
        defaultConfig.addProperty(ConfigKey.DO_ALPHA_SPAWNING, Boolean.valueOf(true));
        defaultConfig.addProperty(ConfigKey.ALPHA_SPAWN_CHANCE, (Number)0.01);
        defaultConfig.addProperty(ConfigKey.ALPHA_SIZE_MULTIPLIER, (Number)2.0);
        defaultConfig.addProperty(ConfigKey.MAXIMUM_BEST_IVS, (Number)3);
        defaultConfig.addProperty(ConfigKey.DO_HERD_SPAWNING, Boolean.valueOf(true));
        defaultConfig.addProperty(ConfigKey.SECONDS_BETWEEN_SPAWNS, (Number)300);
        defaultConfig.addProperty(ConfigKey.SPAWN_ATTEMPTS, (Number)10);
        defaultConfig.addProperty(ConfigKey.REQUIRED_PLAYER_AMOUNT, (Number)1);
        defaultConfig.addProperty(ConfigKey.SHINY_ODDS, (Number)4096);
        defaultConfig.addProperty(ConfigKey.MINIMUM_SPAWN_DISTANCE, (Number)30);
        defaultConfig.addProperty(ConfigKey.MAXIMUM_SPAWN_DISTANCE, (Number)60);
        defaultConfig.addProperty(ConfigKey.SPAWN_ANNOUNCEMENT_MESSAGE, "An Alpha Pokemon has spawned near somebody!");
        defaultConfig.addProperty(ConfigKey.SHOW_COORDS_IN_ANNOUNCEMENT, Boolean.valueOf(false));
    }

    private static void rewriteConfig(Gson gson, JsonObject defaultConfig, JsonObject finalConfig) {
        defaultConfig.keySet().stream().filter(k -> !finalConfig.has(k)).forEach(k -> {
            CobblemonAlphasMod.LOGGER.info("Adding new field '{}' to the config", k);
            finalConfig.add(k, defaultConfig.get(k));
        });
        try {
            Files.createDirectories(Paths.get(fullConfigPath.toString(), new String[0]).getParent(), new FileAttribute[0]);
            FileWriter writer = new FileWriter(fullConfigPath.toString());
            gson.toJson((JsonElement)finalConfig, (Appendable)writer);
            writer.close();
        }
        catch (IOException ioException) {
            CobblemonAlphasMod.LOGGER.warn("Could not create new config");
        }
    }

    private static void loadConfig(JsonObject finalConfiguration) {
        doAlphaSpawning = finalConfiguration.get(ConfigKey.DO_ALPHA_SPAWNING).getAsBoolean();
        alphaSpawnChance = finalConfiguration.get(ConfigKey.ALPHA_SPAWN_CHANCE).getAsFloat();
        alphaSizeMultiplier = finalConfiguration.get(ConfigKey.ALPHA_SIZE_MULTIPLIER).getAsFloat();
        maximumBestIVs = finalConfiguration.get(ConfigKey.MAXIMUM_BEST_IVS).getAsInt();
        doHerdSpawning = finalConfiguration.get(ConfigKey.DO_HERD_SPAWNING).getAsBoolean();
        ticksBetweenSpawns = finalConfiguration.get(ConfigKey.SECONDS_BETWEEN_SPAWNS).getAsInt() * 20;
        spawnAttempts = finalConfiguration.get(ConfigKey.SPAWN_ATTEMPTS).getAsInt();
        requiredPlayerAmount = finalConfiguration.get(ConfigKey.REQUIRED_PLAYER_AMOUNT).getAsInt();
        shinyOdds = finalConfiguration.get(ConfigKey.SHINY_ODDS).getAsInt();
        minimumSpawnDistance = finalConfiguration.get(ConfigKey.MINIMUM_SPAWN_DISTANCE).getAsInt();
        maximumSpawnDistance = finalConfiguration.get(ConfigKey.MAXIMUM_SPAWN_DISTANCE).getAsInt();
        spawnAnnouncementMessage = finalConfiguration.get(ConfigKey.SPAWN_ANNOUNCEMENT_MESSAGE).getAsString();
        showCoordinatesInAnnouncement = finalConfiguration.get(ConfigKey.SHOW_COORDS_IN_ANNOUNCEMENT).getAsBoolean();
    }
}

