/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.blockEntity;

import dev.cudzer.cobblemonalphas.block.ModBlocks;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AlphaSpawnBlockEntity
extends BlockEntity {
    protected int ticks = 0;
    private static final String ALPHA_ID_KEY = "AlphaId";
    private ResourceLocation forcedAlpha = null;

    public AlphaSpawnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.ALPHA_SPAWNER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public ResourceLocation getForcedAlpha() {
        return this.forcedAlpha;
    }

    public void setForcedAlpha(ResourceLocation id) {
        this.forcedAlpha = id;
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.forcedAlpha = tag.contains(ALPHA_ID_KEY) ? ResourceLocation.tryParse((String)tag.getString(ALPHA_ID_KEY)) : null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.forcedAlpha != null) {
            tag.putString(ALPHA_ID_KEY, this.forcedAlpha.toString());
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, AlphaSpawnBlockEntity be) {
        if (++be.ticks % 40 != 0) {
            return;
        }
        if (level == null || !level.isLoaded(blockPos)) {
            return;
        }
        if (blockState == null) {
            return;
        }
        Player player = level.getNearestPlayer((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 8.0, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        if (player == null) {
            return;
        }
        Alpha alpha = null;
        if (be.getForcedAlpha() != null) {
            alpha = AlphaJsonDataManager.getAlphaById(be.getForcedAlpha());
        }
        if (alpha == null) {
            Map<ResourceLocation, Alpha> alphaMap = AlphaJsonDataManager.getRandomAlphaForBiome(level, (ResourceKey<Biome>)((ResourceKey)level.getBiome(blockPos).unwrapKey().get()), false);
            if (alphaMap == null || alphaMap.isEmpty()) {
                return;
            }
            alpha = alphaMap.values().iterator().next();
        }
        level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
        AlphaSpawner.getInstance().spawnAlphaEntity(alpha, level, (Vec3i)blockPos, ModConfig.doHerdSpawning);
    }
}

