/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.management.openmbean.InvalidOpenTypeException;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.misc.TriResult;
import net.mehvahdjukaar.moonlight.api.resources.RecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RPUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeJson(JsonElement json) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject deserializeJson(InputStream stream) {
        return GsonHelper.parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block) throws FileNotFoundException {
        return RPUtils.findFirstBlockTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block, Predicate<String> texturePredicate) throws FileNotFoundException {
        String t;
        ResourceLocation blockId = Utils.getID(block);
        TriResult<String> cached = TextureCache.getCachedTexture((ItemLike)block, texturePredicate);
        if (cached.isSuccess()) {
            return ResourceLocation.parse((String)cached.getObject());
        }
        if (!cached.isPass()) throw new FileNotFoundException("Could not find any texture associated to the given block " + String.valueOf(blockId));
        Optional blockState = manager.getResource(ResType.BLOCKSTATES.getPath(blockId));
        try (InputStream bsStream2222 = ((Resource)blockState.orElseThrow()).open();){
            JsonObject bsElement = RPUtils.deserializeJson(bsStream2222);
            Set<String> models = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model"));
            for (String modelPath : models) {
                List<String> textures = RPUtils.findAllTexturesInModelRecursive(manager, modelPath);
                for (String t2 : textures) {
                    TextureCache.add((ItemLike)block, t2);
                }
            }
            cached = TextureCache.getCachedTexture((ItemLike)block, texturePredicate);
            if (cached.isSuccess()) {
                ResourceLocation resourceLocation = ResourceLocation.parse((String)cached.getObject());
                return resourceLocation;
            }
        }
        catch (Exception bsStream2222) {
            // empty catch block
        }
        List<String> hack = RPUtils.guessBlockTextureLocation(blockId, block);
        Iterator<String> iterator = hack.iterator();
        do {
            if (!iterator.hasNext()) throw new FileNotFoundException("Could not find any texture associated to the given block " + String.valueOf(blockId));
            t = iterator.next();
            TextureCache.add((ItemLike)block, t);
        } while (!texturePredicate.test(t));
        return ResourceLocation.parse((String)t);
    }

    private static Set<String> guessItemTextureLocation(ResourceLocation id, Item item) {
        return Set.of(id.getNamespace() + ":item/" + String.valueOf(item));
    }

    private static List<String> guessBlockTextureLocation(ResourceLocation id, Block block) {
        String key;
        String name = id.getPath();
        ArrayList<String> textures = new ArrayList<String>();
        WoodType w = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)block);
        if (w != null && (Objects.equals(key = w.getChildKey(block), "log") || Objects.equals(key, "stripped_log"))) {
            textures.add(id.getNamespace() + ":block/" + name + "_top");
            textures.add(id.getNamespace() + ":block/" + name + "_side");
        }
        textures.add(id.getNamespace() + ":block/" + name);
        return textures;
    }

    @NotNull
    private static List<String> findAllTexturesInModelRecursive(ResourceManager manager, String modelPath) throws Exception {
        JsonObject modelElement;
        try (InputStream modelStream = ((Resource)manager.getResource(ResType.MODELS.getPath(modelPath)).get()).open();){
            modelElement = RPUtils.deserializeJson(modelStream).getAsJsonObject();
        }
        catch (Exception e) {
            throw new Exception("Failed to parse model at " + modelPath);
        }
        ArrayList<String> textures = new ArrayList<String>(RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject("textures")));
        if (textures.isEmpty() && modelElement.has("parent")) {
            String parentPath = modelElement.get("parent").getAsString();
            textures.addAll(RPUtils.findAllTexturesInModelRecursive(manager, parentPath));
        }
        return textures;
    }

    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item block) throws FileNotFoundException {
        return RPUtils.findFirstItemTextureLocation(manager, block, t -> true);
    }

    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item item, Predicate<String> texturePredicate) throws FileNotFoundException {
        ResourceLocation itemId = Utils.getID(item);
        TriResult<String> cached = TextureCache.getCachedTexture((ItemLike)item, texturePredicate);
        if (cached.isSuccess()) {
            return ResourceLocation.parse((String)cached.getObject());
        }
        if (cached.isPass()) {
            Set<String> textures;
            Optional itemModel = manager.getResource(ResType.ITEM_MODELS.getPath(itemId));
            try (InputStream stream = ((Resource)itemModel.orElseThrow()).open();){
                JsonObject bsElement = RPUtils.deserializeJson(stream);
                textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures"));
            }
            catch (Exception ignored) {
                textures = RPUtils.guessItemTextureLocation(itemId, item);
            }
            for (String t : textures) {
                TextureCache.add((ItemLike)item, t);
            }
            cached = TextureCache.getCachedTexture((ItemLike)item, texturePredicate);
            if (cached.isSuccess()) {
                return ResourceLocation.parse((String)cached.getObject());
            }
        }
        throw new FileNotFoundException("Could not find any texture associated to the given item " + String.valueOf(itemId));
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            HashSet<String> list = new HashSet<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e, filter)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            HashSet<String> list = new HashSet<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                Set<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return Set.of(element.getAsString());
    }

    public static Recipe<?> readRecipe(ResourceManager manager, String location) {
        return RPUtils.readRecipeAbsolute(manager, ResType.RECIPES.getPath(location));
    }

    public static Recipe<?> readRecipe(ResourceManager manager, ResourceLocation location) {
        return RPUtils.readRecipeAbsolute(manager, ResType.RECIPES.getPath(location));
    }

    private static Recipe<?> readRecipeAbsolute(ResourceManager manager, ResourceLocation location) {
        Recipe<?> recipe;
        block8: {
            Optional resource = manager.getResource(location);
            InputStream stream = ((Resource)resource.orElseThrow()).open();
            try {
                JsonObject element = RPUtils.deserializeJson(stream);
                recipe = RPUtils.readRecipe((JsonElement)element);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
                }
            }
            stream.close();
        }
        return recipe;
    }

    public static Recipe<?> readRecipe(JsonElement element) {
        return (Recipe)Recipe.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow();
    }

    public static <T extends Recipe<?>> JsonElement writeRecipe(T recipe) {
        return (JsonElement)Recipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, recipe).getOrThrow();
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> RecipeHolder<?> makeSimilarRecipe(Recipe<?> original, T originalMat, T destinationMat, String baseID) {
        return RPUtils.makeSimilarRecipe(original, originalMat, destinationMat, ResourceLocation.parse((String)baseID));
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> RecipeHolder<?> makeSimilarRecipe(Recipe<?> original, T originalMat, T destinationMat, ResourceLocation baseID) {
        return RecipeTemplate.makeSimilarRecipe(original, originalMat, destinationMat, baseID);
    }

    public static Path getResourcePath(Path path, ResourceLocation k, PackType packType) {
        return path.resolve(packType.getDirectory()).resolve(k.getNamespace()).resolve(k.getPath());
    }

    public static void writeResource(ResourceLocation id, byte[] bytes, Path path, PackType packType) {
        Path p = RPUtils.getResourcePath(path, id, packType);
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.write(p, bytes, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(forRemoval=true)
    public static void appendModelOverride(ResourceManager manager, DynamicTexturePack pack, ResourceLocation modelRes, Consumer<OverrideAppender> modelConsumer) {
        Optional o = manager.getResource(ResType.ITEM_MODELS.getPath(modelRes));
        if (o.isPresent()) {
            try (InputStream model = ((Resource)o.get()).open();){
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.has("overrides") ? json.getAsJsonArray("overrides") : new JsonArray();
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeModelOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                pack.addItemModel(modelRes, (JsonElement)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void appendModelOverride(ResourceManager manager, ResourceSink pack, ResourceLocation modelRes, Consumer<OverrideAppender> modelConsumer) {
        JsonElement json = RPUtils.makeModelOverride(manager, modelRes, modelConsumer);
        pack.addItemModel(modelRes, json);
    }

    public static JsonElement makeModelOverride(ResourceManager manager, ResourceLocation modelRes, Consumer<OverrideAppender> modelConsumer) {
        JsonObject jsonObject;
        block8: {
            InputStream model = manager.getResourceOrThrow(ResType.ITEM_MODELS.getPath(modelRes)).open();
            try {
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.has("overrides") ? json.getAsJsonArray("overrides") : new JsonArray();
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeModelOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                jsonObject = json;
                if (model == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (model != null) {
                        try {
                            model.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            model.close();
        }
        return jsonObject;
    }

    private static JsonObject serializeModelOverride(ItemOverride override) {
        JsonObject json = new JsonObject();
        json.addProperty("model", override.getModel().toString());
        JsonObject predicates = new JsonObject();
        override.getPredicates().forEach(p -> predicates.addProperty(p.getProperty().toString(), (Number)Float.valueOf(p.getValue())));
        json.add("predicate", (JsonElement)predicates);
        return json;
    }

    @FunctionalInterface
    public static interface OverrideAppender {
        public void add(ItemOverride var1);
    }
}

