/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather.content.item;

import be.ephys.magicfeather.MFConfig;
import be.ephys.magicfeather.content.MFItems;
import be.ephys.magicfeather.content.item.AbstractFeatherItem;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class PrimevalFeatherItem
extends AbstractFeatherItem {
    public static final WeakHashMap<Player, PrimevalFeatherData> GLOBAL_PLAYER_DATA = new WeakHashMap();

    public PrimevalFeatherItem() {
        super(new Item.Properties().stacksTo(1).durability(128));
    }

    public boolean isDamageable() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            if (PrimevalFeatherItem.requiresCurios() && !PrimevalFeatherItem.isCuriosEquipped((Player)player, (Item)MFItems.PRIMEVAL_FEATHER.get())) {
                tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip.requires_curios")).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            }
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip.description")).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }

    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        PrimevalFeatherData data = GLOBAL_PLAYER_DATA.get(player);
        if (data == null || data.player != player) {
            data = new PrimevalFeatherData(player);
            GLOBAL_PLAYER_DATA.put(player, data);
        }
        data.onTick();
    }

    private static class PrimevalFeatherData {
        private final Player player;
        private boolean isSoftLanding = false;
        private boolean wasGrantedFlight = false;
        private boolean isSlowFalling = false;
        private int checkTick = 0;

        public PrimevalFeatherData(Player player) {
            this.player = player;
        }

        public void onTick() {
            boolean mayFly;
            if (this.player.isSpectator()) {
                return;
            }
            boolean bl = mayFly = this.player.isCreative() || AbstractFeatherItem.hasItem(this.player, (Item)MFItems.PRIMEVAL_FEATHER.get());
            if (this.checkTick++ % 20 == 0 && this.player.getAbilities().flying && AbstractFeatherItem.hasItem(this.player, (Item)MFItems.PRIMEVAL_FEATHER.get()) && this.player.getDeltaMovement().length() < 0.01) {
                ItemStack featherItemStack = null;
                if (AbstractFeatherItem.isCuriosInstalled()) {
                    featherItemStack = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)this.player, (Item)MFItems.PRIMEVAL_FEATHER.get()).get()).stack();
                }
                for (int i = 0; i < this.player.getInventory().getContainerSize(); ++i) {
                    ItemStack stack = this.player.getInventory().getItem(i);
                    if (!(stack.getItem() instanceof PrimevalFeatherItem)) continue;
                    featherItemStack = stack;
                }
                if (featherItemStack != null) {
                    featherItemStack.hurtAndBreak(1, (LivingEntity)this.player, this.player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
            }
            if (mayFly) {
                AbstractFeatherItem.setMayFly(this.player, true);
                this.isSoftLanding = false;
            } else if (this.wasGrantedFlight) {
                this.isSoftLanding = true;
            }
            if (this.isSoftLanding && this.softLand()) {
                this.isSoftLanding = false;
            }
            this.wasGrantedFlight = mayFly;
        }

        private boolean softLand() {
            if (MFConfig.fallStyle.get() == AbstractFeatherItem.FallStyle.SLOW_FALL) {
                return this.slowFall();
            }
            return this.negateFallDamage();
        }

        private boolean slowFall() {
            boolean isPlayerOnGround;
            Abilities abilities = this.player.getAbilities();
            if (abilities.flying) {
                this.isSlowFalling = true;
                abilities.flying = false;
            }
            abilities.mayfly = false;
            this.player.onUpdateAbilities();
            boolean bl = isPlayerOnGround = this.player.onGround() && this.player.fallDistance < 1.0f;
            if (isPlayerOnGround) {
                this.isSlowFalling = false;
            } else if (this.isSlowFalling && this.checkTick++ % 5 != 0) {
                this.player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 10, 0, false, false));
            }
            return isPlayerOnGround;
        }

        private boolean negateFallDamage() {
            boolean isPlayerOnGround;
            boolean bl = isPlayerOnGround = this.player.onGround() && this.player.fallDistance < 1.0f;
            if (isPlayerOnGround) {
                AbstractFeatherItem.setMayFly(this.player, false);
                return true;
            }
            if (this.player.getAbilities().flying) {
                this.player.getAbilities().flying = false;
                this.player.onUpdateAbilities();
            }
            return false;
        }
    }
}

