/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather.content.item;

import be.ephys.magicfeather.MFConfig;
import be.ephys.magicfeather.content.MFItems;
import be.ephys.magicfeather.content.item.AbstractFeatherItem;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ArcaneFeatherItem
extends AbstractFeatherItem {
    public static final WeakHashMap<Player, ArcaneFeatherData> GLOBAL_PLAYER_DATA = new WeakHashMap();

    public ArcaneFeatherItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            if (ArcaneFeatherItem.requiresCurios() && !ArcaneFeatherItem.isCuriosEquipped((Player)player, (Item)MFItems.ARCANE_FEATHER.get())) {
                tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip.requires_curios")).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            }
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip.description")).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }

    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        ArcaneFeatherData data = GLOBAL_PLAYER_DATA.get(player);
        if (data == null || data.player != player) {
            data = new ArcaneFeatherData(player);
            GLOBAL_PLAYER_DATA.put(player, data);
        }
        data.onTick();
    }

    private static class ArcaneFeatherData {
        private final Player player;
        private boolean isSoftLanding = false;
        private boolean wasGrantedFlight = false;
        private boolean isSlowFalling = false;
        private int checkTick = 0;

        public ArcaneFeatherData(Player player) {
            this.player = player;
        }

        public void onTick() {
            boolean mayFly;
            if (this.player.isSpectator()) {
                return;
            }
            boolean bl = mayFly = this.player.isCreative() || AbstractFeatherItem.hasItem(this.player, (Item)MFItems.ARCANE_FEATHER.get());
            if (mayFly) {
                AbstractFeatherItem.setMayFly(this.player, true);
                this.isSoftLanding = false;
            } else if (this.wasGrantedFlight) {
                this.isSoftLanding = true;
            }
            if (this.isSoftLanding && this.softLand()) {
                this.isSoftLanding = false;
            }
            this.wasGrantedFlight = mayFly;
        }

        private boolean softLand() {
            if (MFConfig.fallStyle.get() == AbstractFeatherItem.FallStyle.SLOW_FALL) {
                return this.slowFall();
            }
            return this.negateFallDamage();
        }

        private boolean slowFall() {
            boolean isPlayerOnGround;
            Abilities abilities = this.player.getAbilities();
            if (abilities.flying) {
                this.isSlowFalling = true;
                abilities.flying = false;
            }
            abilities.mayfly = false;
            this.player.onUpdateAbilities();
            boolean bl = isPlayerOnGround = this.player.onGround() && this.player.fallDistance < 1.0f;
            if (isPlayerOnGround) {
                this.isSlowFalling = false;
            } else if (this.isSlowFalling && this.checkTick++ % 5 != 0) {
                this.player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 10, 0, false, false));
            }
            return isPlayerOnGround;
        }

        private boolean negateFallDamage() {
            boolean isPlayerOnGround;
            boolean bl = isPlayerOnGround = this.player.onGround() && this.player.fallDistance < 1.0f;
            if (isPlayerOnGround) {
                AbstractFeatherItem.setMayFly(this.player, false);
                return true;
            }
            if (this.player.getAbilities().flying) {
                this.player.getAbilities().flying = false;
                this.player.onUpdateAbilities();
            }
            return false;
        }
    }
}

