/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather.content.item;

import be.ephys.magicfeather.MFConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;

public class AbstractFeatherItem
extends Item {
    public AbstractFeatherItem(Item.Properties properties) {
        super(properties);
    }

    public int getEntityLifespan(ItemStack itemStack, Level world) {
        return Integer.MAX_VALUE;
    }

    public static void setMayFly(Player player, boolean mayFly) {
        if (player.getAbilities().mayfly == mayFly) {
            return;
        }
        player.getAbilities().mayfly = mayFly;
        player.onUpdateAbilities();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public static boolean requiresCurios() {
        return AbstractFeatherItem.isCuriosInstalled() && (Boolean)MFConfig.looseRequiresCurios.get() != false;
    }

    public static boolean isCuriosInstalled() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean isCuriosEquipped(Player player, Item item) {
        return CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, item).isPresent();
    }

    public static boolean hasItem(Player player, Item item) {
        if (AbstractFeatherItem.isCuriosInstalled()) {
            if (AbstractFeatherItem.isCuriosEquipped(player, item)) {
                return true;
            }
            if (((Boolean)MFConfig.looseRequiresCurios.get()).booleanValue()) {
                return false;
            }
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!item.equals(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public Entity createEntity(Level world, Entity entity, ItemStack itemstack) {
        entity.setInvulnerable(true);
        return null;
    }

    public static enum FallStyle {
        SLOW_FALL,
        NEGATE_FALL_DAMAGE;

    }
}

