/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableSerializer;
import vazkii.patchouli.api.VariableHelper;
import vazkii.patchouli.client.book.template.variable.GenericArrayVariableSerializer;
import vazkii.patchouli.client.book.template.variable.IngredientVariableSerializer;
import vazkii.patchouli.client.book.template.variable.ItemStackArrayVariableSerializer;
import vazkii.patchouli.client.book.template.variable.ItemStackVariableSerializer;
import vazkii.patchouli.client.book.template.variable.TextComponentVariableSerializer;
import vazkii.patchouli.client.book.template.variable.Variable;

public class VariableHelperImpl
implements VariableHelper {
    public Map<Class<?>, IVariableSerializer<?>> serializers = new HashMap();

    public VariableHelperImpl() {
        this.registerSerializer(new ItemStackVariableSerializer(), ItemStack.class);
        this.registerSerializer(new ItemStackArrayVariableSerializer(), ItemStack[].class);
        this.registerSerializer(new IngredientVariableSerializer(), Ingredient.class);
        this.registerSerializer(new TextComponentVariableSerializer(), Component.class);
    }

    @Override
    public <T> IVariableSerializer<T> serializerForClass(Class<T> clazz) {
        Class<?> componentType;
        IVariableSerializer<?> componentSerializer;
        IVariableSerializer<?> serializer = this.serializers.get(clazz);
        if (serializer == null && clazz.isArray() && (componentSerializer = this.serializerForClass(componentType = clazz.getComponentType())) != null) {
            GenericArrayVariableSerializer arraySerializer = new GenericArrayVariableSerializer(componentSerializer, componentType);
            this.serializers.put(clazz, arraySerializer);
            return arraySerializer;
        }
        return serializer;
    }

    @Override
    public <T> IVariable createFromObject(T object, HolderLookup.Provider registries) {
        Class<?> clazz = object.getClass();
        for (Map.Entry<Class<?>, IVariableSerializer<?>> e : this.serializers.entrySet()) {
            if (!e.getKey().isAssignableFrom(clazz)) continue;
            return this.create(e.getValue().toJson(object, registries), clazz, registries);
        }
        throw new IllegalArgumentException(String.format("Can't serialize object %s of type %s to IVariable", object, clazz));
    }

    @Override
    public IVariable createFromJson(JsonElement elem, HolderLookup.Provider registries) {
        return this.create(elem, null, registries);
    }

    private IVariable create(JsonElement elem, Class<?> originator, HolderLookup.Provider registries) {
        return new Variable(elem, originator, registries);
    }

    @Override
    public <T> VariableHelper registerSerializer(IVariableSerializer<T> serializer, Class<T> clazz) {
        this.serializers.put(clazz, serializer);
        return this;
    }
}

