/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.recipe;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.jearchaeology.compat.CompatHandler;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class Helper {
    private static final UUID BRUSHER_PLAYER_UUID = UUID.nameUUIDFromBytes("jea_brusher_player".getBytes(StandardCharsets.UTF_8));
    private static List<RecipeHolder<?>> cachedBrushingRecipes = new ArrayList();
    private static List<RecipeHolder<?>> cachedSniffingRecipes = new ArrayList();

    public static List<RecipeHolder<?>> getAllBrushingRecipes(ServerLevel level) {
        if (level != null && cachedBrushingRecipes.isEmpty()) {
            ArrayList recipeList = new ArrayList();
            Map<ResourceKey<LootTable>, Pair<String, Ingredient>> tables = CompatHandler.getTables();
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(BRUSHER_PLAYER_UUID, "jea_brusher_player"));
            LootParams lootparams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)new BlockPos(0, 0, 0))).withLuck(1.0f).withParameter(LootContextParams.THIS_ENTITY, (Object)fakePlayer).create(LootContextParamSets.CHEST);
            tables.forEach((lootTableKey, pair) -> {
                HashMap items = new HashMap();
                LootTable table = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
                if (!table.equals(LootTable.EMPTY)) {
                    for (int i = 0; i < 600; ++i) {
                        table.getRandomItems(lootparams).forEach(itemStack -> {
                            if (!items.containsKey(itemStack.getItem())) {
                                items.put(itemStack.getItem(), itemStack);
                            }
                        });
                    }
                }
                String locationName = (String)pair.getFirst();
                if (items.size() > 64) {
                    recipeList.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)(locationName + "_4")), (Recipe)new BrushingRecipe(Ingredient.of((ItemStack[])items.values().stream().limit(42L).skip(21L).toList().toArray(new ItemStack[0])), 1.0f, (Ingredient)pair.getSecond())));
                    recipeList.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)(locationName + "_3")), (Recipe)new BrushingRecipe(Ingredient.of((ItemStack[])items.values().stream().skip(42L).toList().toArray(new ItemStack[0])), 1.0f, (Ingredient)pair.getSecond())));
                }
                if (items.size() > 32) {
                    recipeList.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)(locationName + "_2")), (Recipe)new BrushingRecipe(Ingredient.of((ItemStack[])items.values().stream().limit(21L).toList().toArray(new ItemStack[0])), 1.0f, (Ingredient)pair.getSecond())));
                    recipeList.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)(locationName + "_1")), (Recipe)new BrushingRecipe(Ingredient.of((ItemStack[])items.values().stream().skip(21L).toList().toArray(new ItemStack[0])), 1.0f, (Ingredient)pair.getSecond())));
                } else {
                    recipeList.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)locationName), (Recipe)new BrushingRecipe(Ingredient.of((ItemStack[])items.values().toArray(new ItemStack[0])), 1.0f, (Ingredient)pair.getSecond())));
                }
            });
            cachedBrushingRecipes = recipeList;
        }
        return cachedBrushingRecipes;
    }

    public static List<RecipeHolder<?>> getAllSniffingRecipes(ServerLevel level) {
        if (level != null && cachedSniffingRecipes.isEmpty()) {
            Sniffer sniffer = (Sniffer)EntityType.SNIFFER.create((Level)level);
            LootParams lootparams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)new Vec3(0.0, 0.0, 0.0)).withParameter(LootContextParams.THIS_ENTITY, (Object)sniffer).create(LootContextParamSets.GIFT);
            HashMap items = new HashMap();
            LootTable table = level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SNIFFER_DIGGING);
            for (int i = 0; i < 400; ++i) {
                table.getRandomItems(lootparams).forEach(itemStack -> {
                    if (!items.containsKey(itemStack.getItem())) {
                        items.put(itemStack.getItem(), itemStack);
                    }
                });
            }
            cachedSniffingRecipes = List.of(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)"sniffing"), (Recipe)new SniffRecipe(Ingredient.of((ItemStack[])items.values().toArray(new ItemStack[0])), 1.0f)));
        }
        return cachedSniffingRecipes;
    }
}

