/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology;

import com.mojang.logging.LogUtils;
import cy.jdkdigital.jearchaeology.Config;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import cy.jdkdigital.jearchaeology.recipe.Helper;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="jearchaeology")
public class JEArchaeology {
    public static final String MODID = "jearchaeology";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"jearchaeology");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"jearchaeology");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"jearchaeology");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"jearchaeology");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"jearchaeology");
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<SniffRecipe>> SNIFF = RECIPE_SERIALIZERS.register("sniff", SniffRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<BrushingRecipe>> BRUSH = RECIPE_SERIALIZERS.register("brush", BrushingRecipe.Serializer::new);
    public static DeferredHolder<RecipeType<?>, RecipeType<SniffRecipe>> SNIFF_TYPE = RECIPE_TYPES.register("sniff", () -> new RecipeType<SniffRecipe>(){});
    public static DeferredHolder<RecipeType<?>, RecipeType<BrushingRecipe>> BRUSH_TYPE = RECIPE_TYPES.register("brush", () -> new RecipeType<BrushingRecipe>(){});

    public JEArchaeology(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @EventBusSubscriber(modid="jearchaeology")
    class Events {
        Events(JEArchaeology this$0) {
        }

        @SubscribeEvent
        public static void onDataSync(OnDatapackSyncEvent event) {
            RecipeManager recipeManager;
            List sniffRecipes;
            Optional player = event.getRelevantPlayers().findFirst();
            if (player.isPresent() && ((ServerPlayer)player.get()).getServer() != null && (sniffRecipes = (recipeManager = ((ServerPlayer)player.get()).getServer().getRecipeManager()).getAllRecipesFor((RecipeType)SNIFF_TYPE.get())).size() == 0) {
                ArrayList allRecipes = new ArrayList(recipeManager.getRecipes());
                allRecipes.addAll(Helper.getAllBrushingRecipes(event.getPlayerList().getServer().getLevel(Level.OVERWORLD)));
                allRecipes.addAll(Helper.getAllSniffingRecipes(event.getPlayerList().getServer().getLevel(Level.OVERWORLD)));
                recipeManager.replaceRecipes(allRecipes);
            }
        }
    }

    @EventBusSubscriber(modid="jearchaeology", bus=EventBusSubscriber.Bus.MOD)
    class ModEvents {
        ModEvents(JEArchaeology this$0) {
        }

        @SubscribeEvent
        public static void payloadHandler(RegisterPayloadHandlersEvent event) {
        }
    }
}

