/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.command.CountWaystonesCommand;
import net.blay09.mods.waystones.command.OpenPlayerWaystonesGuiCommand;
import net.blay09.mods.waystones.comparator.WaystoneComparators;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModCommands {
    private static final SimpleCommandExceptionType ERROR_WAYSTONE_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.waystones.waystone_not_found"));
    private static final ResourceLocation PERMISSION_WAYSTONES_ACTIVATE = ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"command.waystones.activate");
    private static final ResourceLocation PERMISSION_WAYSTONES_FORGET = ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"command.waystones.forget");
    private static final ResourceLocation PERMISSION_WAYSTONES_COUNT = ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"command.waystones.count");
    private static final ResourceLocation PERMISSION_WAYSTONES_LIST = ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"command.waystones.list");
    private static final ResourceLocation PERMISSION_WAYSTONES_GUI = ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"command.waystones.gui");

    public static void initialize(BalmCommands commands) {
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_WAYSTONES_ACTIVATE, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_WAYSTONES_FORGET, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_WAYSTONES_COUNT, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_WAYSTONES_LIST, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_WAYSTONES_GUI, (int)2);
        commands.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"waystones").requires(BalmCommands.requireAnyPermission((ResourceLocation[])new ResourceLocation[]{PERMISSION_WAYSTONES_ACTIVATE, PERMISSION_WAYSTONES_FORGET, PERMISSION_WAYSTONES_COUNT, PERMISSION_WAYSTONES_LIST, PERMISSION_WAYSTONES_GUI}))).then(((LiteralArgumentBuilder)Commands.literal((String)"activate").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_WAYSTONES_ACTIVATE))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
            Optional<Waystone> foundWaystone = WaystonesAPI.getWaystoneAt(((CommandSourceStack)context.getSource()).getLevel(), pos);
            if (foundWaystone.isPresent()) {
                Waystone waystone = foundWaystone.get();
                for (ServerPlayer player : targets) {
                    WaystonesAPI.activateWaystone(player, waystone);
                }
                if (targets.size() == 1) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.activate.success.single", (Object[])new Object[]{waystone.getName(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
                } else {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.activate.success.multiple", (Object[])new Object[]{waystone.getName(), targets.size()}), true);
                }
            } else {
                throw ERROR_WAYSTONE_NOT_FOUND.create();
            }
            return targets.size();
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"forget").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_WAYSTONES_FORGET))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
            Optional<Waystone> foundWaystone = WaystonesAPI.getWaystoneAt(((CommandSourceStack)context.getSource()).getLevel(), pos);
            if (foundWaystone.isPresent()) {
                Waystone waystone = foundWaystone.get();
                for (ServerPlayer player : targets) {
                    WaystonesAPI.deactivateWaystone(player, waystone);
                }
                if (targets.size() == 1) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.forget.success.single", (Object[])new Object[]{waystone.getName(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
                } else {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.forget.success.multiple", (Object[])new Object[]{waystone.getName(), targets.size()}), true);
                }
            } else {
                throw ERROR_WAYSTONE_NOT_FOUND.create();
            }
            return targets.size();
        }))).then(Commands.literal((String)"all").executes(context -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            int totalDeactivated = 0;
            for (ServerPlayer player : targets) {
                Collection<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)player);
                for (Waystone waystone : waystones) {
                    WaystonesAPI.deactivateWaystone(player, waystone);
                }
                totalDeactivated += waystones.size();
            }
            if (targets.size() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.forget.all.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.waystones.forget.all.success.multiple", (Object[])new Object[]{targets.size()}), true);
            }
            return totalDeactivated;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"count").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_WAYSTONES_COUNT))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes((Command)new CountWaystonesCommand())))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_WAYSTONES_LIST))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)ctx.getSource());
            List<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().filter(it -> it.isOwner((Player)target)).sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.waystones.list.header", (Object[])new Object[]{target.getScoreboardName()}));
            for (Waystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            MutableComponent result = Component.translatable((String)"commands.waystones.list.footer", (Object[])new Object[]{waystones.size()});
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
            return waystones.size();
        })).then(Commands.literal((String)"all").executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)ctx.getSource());
            List<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.waystones.list.all.header", (Object[])new Object[]{target.getScoreboardName()}));
            for (Waystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            long ownedCount = waystones.stream().filter(it -> it.isOwner((Player)target)).count();
            MutableComponent result = Component.translatable((String)"commands.waystones.list.all.footer", (Object[])new Object[]{waystones.size(), ownedCount});
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
            return waystones.size();
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"gui").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_WAYSTONES_GUI))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes((Command)new OpenPlayerWaystonesGuiCommand())))));
    }

    private static Component componentForWaystoneList(ServerPlayer caller, ServerPlayer target, Waystone waystone) {
        MutableComponent location;
        ResourceLocation waystoneDimensionId = waystone.getDimension().location();
        BlockPos waystonePos = waystone.getPos();
        if (waystone.getDimension() != caller.level().dimension()) {
            location = Component.translatable((String)"commands.waystones.list.in_dimension", (Object[])new Object[]{waystoneDimensionId.toString()});
        } else {
            int distance = (int)caller.position().distanceTo(waystonePos.getCenter());
            location = Component.translatable((String)"commands.waystones.list.at_distance", (Object[])new Object[]{distance});
        }
        String suggestedCommand = String.format("/execute in %s run teleport %d %d %d", waystoneDimensionId, waystonePos.getX(), waystonePos.getY(), waystonePos.getZ());
        MutableComponent coordinates = Component.translatable((String)"commands.waystones.list.coordinates", (Object[])new Object[]{waystonePos.getX(), waystonePos.getY(), waystonePos.getZ()}).withStyle(ChatFormatting.YELLOW).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        MutableComponent waystoneName = waystone.getName().copy().withStyle(ChatFormatting.GREEN).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        String entryKey = waystone.isOwner((Player)target) ? "commands.waystones.list.entry.owned" : "commands.waystones.list.entry.activated";
        return Component.translatable((String)entryKey, (Object[])new Object[]{location, coordinates, waystoneName});
    }
}

